/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerAeadAes256CbcHmac256EncryptionKey;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithm;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class SQLServerAeadAes256CbcHmac256Algorithm
extends SQLServerEncryptionAlgorithm {
    static final String algorithmName = "AEAD_AES_256_CBC_HMAC_SHA256";
    private SQLServerAeadAes256CbcHmac256EncryptionKey columnEncryptionkey;
    private byte algorithmVersion;
    private boolean isDeterministic = false;
    private int blockSizeInBytes = 16;
    private int keySizeInBytes = 32;
    private byte[] version = new byte[]{1};
    private byte[] versionSize = new byte[]{1};
    private int minimumCipherTextLengthInBytesNoAuthenticationTag = 1 + this.blockSizeInBytes + this.blockSizeInBytes;
    private int minimumCipherTextLengthInBytesWithAuthenticationTag = this.minimumCipherTextLengthInBytesNoAuthenticationTag + this.keySizeInBytes;

    SQLServerAeadAes256CbcHmac256Algorithm(SQLServerAeadAes256CbcHmac256EncryptionKey sQLServerAeadAes256CbcHmac256EncryptionKey, SQLServerEncryptionType sQLServerEncryptionType, byte by) {
        this.columnEncryptionkey = sQLServerAeadAes256CbcHmac256EncryptionKey;
        if (sQLServerEncryptionType == SQLServerEncryptionType.Deterministic) {
            this.isDeterministic = true;
        }
        this.algorithmVersion = by;
        this.version[0] = by;
    }

    @Override
    byte[] encryptData(byte[] byArray) throws SQLServerException {
        return this.encryptData(byArray, true);
    }

    protected byte[] encryptData(byte[] byArray, boolean bl) throws SQLServerException {
        assert (byArray != null);
        byte[] byArray2 = new byte[this.blockSizeInBytes];
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.columnEncryptionkey.getEncryptionKey(), "AES");
        if (this.isDeterministic) {
            try {
                byArray2 = SQLServerSecurityUtility.getHMACWithSHA256(byArray, this.columnEncryptionkey.getIVKey(), this.blockSizeInBytes);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
                Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
        } else {
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray2);
        }
        int n = byArray.length / this.blockSizeInBytes + 1;
        int n2 = 1;
        int n3 = bl ? this.keySizeInBytes : 0;
        int n4 = n2 + n3;
        int n5 = n4 + this.blockSizeInBytes;
        int n6 = 1 + n3 + byArray2.length + n * this.blockSizeInBytes;
        byte[] byArray3 = new byte[n6];
        byArray3[0] = this.algorithmVersion;
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            int n7 = 0;
            int n8 = n5;
            if (n > 1) {
                n7 = (n - 1) * this.blockSizeInBytes;
                n8 += cipher.update(byArray, 0, n7, byArray3, n8);
            }
            byte[] byArray4 = cipher.doFinal(byArray, n7, byArray.length - n7);
            System.arraycopy(byArray4, 0, byArray3, n8, byArray4.length);
            n8 += byArray4.length;
            if (bl) {
                Mac mac = Mac.getInstance("HmacSHA256");
                SecretKeySpec secretKeySpec2 = new SecretKeySpec(this.columnEncryptionkey.getMacKey(), "HmacSHA256");
                mac.init(secretKeySpec2);
                mac.update(this.version, 0, this.version.length);
                mac.update(byArray2, 0, byArray2.length);
                mac.update(byArray3, n5, n * this.blockSizeInBytes);
                mac.update(this.versionSize, 0, this.version.length);
                byte[] byArray5 = mac.doFinal();
                System.arraycopy(byArray5, 0, byArray3, n2, n3);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray3;
    }

    @Override
    byte[] decryptData(byte[] byArray) throws SQLServerException {
        return this.decryptData(byArray, true);
    }

    private byte[] decryptData(byte[] byArray, boolean bl) throws SQLServerException {
        int n;
        assert (byArray != null);
        byte[] byArray2 = new byte[this.blockSizeInBytes];
        int n2 = n = bl ? this.minimumCipherTextLengthInBytesWithAuthenticationTag : this.minimumCipherTextLengthInBytesNoAuthenticationTag;
        if (byArray.length < n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidCipherTextSize"));
            Object[] objectArray = new Object[]{byArray.length, n};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        int n3 = 0;
        if (byArray[n3] != this.algorithmVersion) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidAlgorithmVersion"));
            Object[] objectArray = new Object[]{String.format("%02X ", byArray[n3]), String.format("%02X ", this.algorithmVersion)};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        ++n3;
        int n4 = 0;
        if (bl) {
            n4 = n3;
            n3 += this.keySizeInBytes;
        }
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        int n5 = n3 += byArray2.length;
        int n6 = byArray.length - n3;
        if (bl) {
            byte[] byArray3;
            try {
                byArray3 = this.prepareAuthenticationTag(byArray2, byArray, n5, n6);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_DecryptionFailed"));
                Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (!SQLServerSecurityUtility.compareBytes(byArray3, byArray, n4, n6)) {
                throw new SQLServerException((Object)this, SQLServerException.getErrString("R_InvalidAuthenticationTag"), null, 0, false);
            }
        }
        return this.decryptData(byArray2, byArray, n5, n6);
    }

    private byte[] decryptData(byte[] byArray, byte[] byArray2, int n, int n2) throws SQLServerException {
        assert (byArray2 != null);
        assert (byArray != null);
        byte[] byArray3 = new byte[n2];
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.columnEncryptionkey.getEncryptionKey(), "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byArray3 = cipher.doFinal(byArray2, n, n2);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_DecryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray3;
    }

    private byte[] prepareAuthenticationTag(byte[] byArray, byte[] byArray2, int n, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        assert (byArray2 != null);
        byte[] byArray3 = new byte[this.keySizeInBytes];
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.columnEncryptionkey.getMacKey(), "HmacSHA256");
        mac.init(secretKeySpec);
        mac.update(this.version, 0, this.version.length);
        mac.update(byArray, 0, byArray.length);
        mac.update(byArray2, n, n2);
        mac.update(this.versionSize, 0, this.version.length);
        byte[] byArray4 = mac.doFinal();
        System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
        return byArray3;
    }
}

