/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DateTimeFormatter;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.OffsetDateTime;
import com.microsoft.sqlserver.jdbc.OffsetTime;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SQLServerBulkCSVFileRecord
implements ISQLServerBulkRecord,
AutoCloseable {
    private BufferedReader fileReader;
    private InputStreamReader sr;
    private FileInputStream fis;
    private Map<Integer, ColumnMetadata> columnMetadata;
    private String currentLine = null;
    private final String delimiter;
    private String[] columnNames = null;
    private DateTimeFormatter dateTimeFormatter = null;
    private DateTimeFormatter timeFormatter = null;
    private static final String loggerClassName = "com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord";
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord");

    public SQLServerBulkCSVFileRecord(String string, String string2, String string3, boolean bl) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCSVFileRecord", new Object[]{string, string2, string3, bl});
        if (null == string) {
            this.throwInvalidArgument("fileToParse");
        } else if (null == string3) {
            this.throwInvalidArgument("delimiter");
        }
        this.delimiter = string3;
        try {
            this.fis = new FileInputStream(string);
            this.sr = null == string2 || 0 == string2.length() ? new InputStreamReader(this.fis) : new InputStreamReader((InputStream)this.fis, string2);
            this.fileReader = new BufferedReader(this.sr);
            if (bl) {
                this.currentLine = this.fileReader.readLine();
                if (null != this.currentLine) {
                    this.columnNames = this.currentLine.split(string3, -1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            throw new SQLServerException(messageFormat.format(new Object[]{string2}), null, 0, null);
        }
        catch (Exception exception) {
            throw new SQLServerException(null, exception.getMessage(), null, 0, false);
        }
        this.columnMetadata = new HashMap<Integer, ColumnMetadata>();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCSVFileRecord");
    }

    public SQLServerBulkCSVFileRecord(String string, String string2, boolean bl) throws SQLServerException {
        this(string, string2, ",", bl);
    }

    public SQLServerBulkCSVFileRecord(String string, boolean bl) throws SQLServerException {
        this(string, null, ",", bl);
    }

    public void addColumnMetadata(int n, String string, int n2, int n3, int n4) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMetadata", new Object[]{n, string, n2, n3, n4});
        String string2 = "";
        if (0 >= n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumnOrdinal"));
            Object[] objectArray = new Object[]{n};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
        }
        if (null != string) {
            string2 = string.trim();
        } else if (this.columnNames != null && this.columnNames.length >= n) {
            string2 = this.columnNames[n - 1];
        }
        if (this.columnNames != null && n > this.columnNames.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
            Object[] objectArray = new Object[]{n};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
        }
        this.checkDuplicateColumnName(n, string);
        switch (n2) {
            case 91: 
            case 92: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, 12, 20, n4));
                break;
            }
            case -155: 
            case 93: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, 12, 35, n4));
                break;
            }
            case 2009: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, -16, n3, n4));
                break;
            }
            case 6: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, 8, n3, n4));
                break;
            }
            case 16: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, -7, n3, n4));
                break;
            }
            default: {
                this.columnMetadata.put(n, new ColumnMetadata(string2, n2, n3, n4));
            }
        }
        loggerExternal.exiting(loggerClassName, "addColumnMetadata");
    }

    public void setTimestampWithTimezoneFormat(String string) {
        loggerExternal.entering(loggerClassName, "setTimestampWithTimezoneFormat", string);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(string);
        loggerExternal.exiting(loggerClassName, "setTimestampWithTimezoneFormat");
    }

    public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        loggerExternal.entering(loggerClassName, "setTimestampWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.dateTimeFormatter = dateTimeFormatter;
        loggerExternal.exiting(loggerClassName, "setTimestampWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(String string) {
        loggerExternal.entering(loggerClassName, "setTimeWithTimezoneFormat", string);
        this.timeFormatter = DateTimeFormatter.ofPattern(string);
        loggerExternal.exiting(loggerClassName, "setTimeWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        loggerExternal.entering(loggerClassName, "setTimeWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.timeFormatter = dateTimeFormatter;
        loggerExternal.exiting(loggerClassName, "setTimeWithTimezoneFormat");
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(loggerClassName, "close");
        if (this.fileReader != null) {
            try {
                this.fileReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sr != null) {
            try {
                this.sr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        loggerExternal.exiting(loggerClassName, "close");
    }

    @Override
    public Set<Integer> getColumnOrdinals() {
        return this.columnMetadata.keySet();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)n)).columnName;
    }

    @Override
    public int getColumnType(int n) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)n)).columnType;
    }

    @Override
    public int getPrecision(int n) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)n)).precision;
    }

    @Override
    public int getScale(int n) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)n)).scale;
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return false;
    }

    @Override
    public Object[] getRowData() throws SQLServerException {
        if (null == this.currentLine) {
            return null;
        }
        String[] stringArray = this.currentLine.split(this.delimiter, -1);
        Object[] objectArray = new Object[stringArray.length];
        for (Map.Entry<Integer, ColumnMetadata> entry : this.columnMetadata.entrySet()) {
            Object object;
            Object object2;
            ColumnMetadata columnMetadata = entry.getValue();
            if (stringArray.length < entry.getKey() - 1) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                object = new Object[]{entry.getKey()};
                throw new SQLServerException(((Format)object2).format(object), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
            }
            if (this.columnNames != null && this.columnNames.length > stringArray.length) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_BulkCSVDataSchemaMismatch"));
                object = new Object[]{};
                throw new SQLServerException(((Format)object2).format(object), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
            }
            if (0 == stringArray[entry.getKey() - 1].length()) {
                objectArray[entry.getKey().intValue() - 1] = null;
                continue;
            }
            try {
                switch (columnMetadata.columnType) {
                    case 4: {
                        object2 = new DecimalFormat("#");
                        object = ((NumberFormat)object2).format(Double.parseDouble(stringArray[entry.getKey() - 1]));
                        objectArray[entry.getKey().intValue() - 1] = Integer.valueOf((String)object);
                        break;
                    }
                    case -6: 
                    case 5: {
                        object2 = new DecimalFormat("#");
                        object = ((NumberFormat)object2).format(Double.parseDouble(stringArray[entry.getKey() - 1]));
                        objectArray[entry.getKey().intValue() - 1] = Short.valueOf((String)object);
                        break;
                    }
                    case -5: {
                        object2 = new BigDecimal(stringArray[entry.getKey() - 1].trim());
                        try {
                            objectArray[entry.getKey().intValue() - 1] = ((BigDecimal)object2).setScale(0, 1).longValueExact();
                            break;
                        }
                        catch (ArithmeticException arithmeticException) {
                            String string = "'" + stringArray[entry.getKey() - 1] + "'";
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                            throw new SQLServerException(messageFormat.format(new Object[]{string, JDBCType.of(columnMetadata.columnType)}), null, 0, null);
                        }
                    }
                    case 2: 
                    case 3: {
                        object2 = new BigDecimal(stringArray[entry.getKey() - 1].trim());
                        objectArray[entry.getKey().intValue() - 1] = ((BigDecimal)object2).setScale(columnMetadata.scale, RoundingMode.HALF_UP);
                        break;
                    }
                    case -7: {
                        try {
                            objectArray[entry.getKey().intValue() - 1] = 0.0 == Double.parseDouble(stringArray[entry.getKey() - 1]) ? Boolean.FALSE : Boolean.TRUE;
                        }
                        catch (NumberFormatException numberFormatException) {
                            objectArray[entry.getKey().intValue() - 1] = Boolean.parseBoolean(stringArray[entry.getKey() - 1]);
                        }
                        break;
                    }
                    case 7: {
                        objectArray[entry.getKey().intValue() - 1] = Float.valueOf(Float.parseFloat(stringArray[entry.getKey() - 1]));
                        break;
                    }
                    case 8: {
                        objectArray[entry.getKey().intValue() - 1] = Double.parseDouble(stringArray[entry.getKey() - 1]);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        object2 = stringArray[entry.getKey() - 1].trim();
                        if (((String)object2).startsWith("0x") || ((String)object2).startsWith("0X")) {
                            objectArray[entry.getKey().intValue() - 1] = ((String)object2).substring(2);
                            break;
                        }
                        objectArray[entry.getKey().intValue() - 1] = object2;
                        break;
                    }
                    case 91: {
                        objectArray[entry.getKey().intValue() - 1] = stringArray[entry.getKey() - 1];
                        break;
                    }
                    case 2013: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                        object2 = null;
                        object2 = this.timeFormatter != null ? OffsetTime.parse(stringArray[entry.getKey() - 1], this.timeFormatter) : OffsetTime.parse(stringArray[entry.getKey() - 1]);
                        objectArray[entry.getKey().intValue() - 1] = object2;
                        break;
                    }
                    case 2014: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                        object2 = null;
                        object2 = this.dateTimeFormatter != null ? OffsetDateTime.parse(stringArray[entry.getKey() - 1], this.dateTimeFormatter) : OffsetDateTime.parse(stringArray[entry.getKey() - 1]);
                        objectArray[entry.getKey().intValue() - 1] = object2;
                        break;
                    }
                    case 0: {
                        objectArray[entry.getKey().intValue() - 1] = null;
                        break;
                    }
                    default: {
                        objectArray[entry.getKey().intValue() - 1] = stringArray[entry.getKey() - 1];
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = "'" + stringArray[entry.getKey() - 1] + "'";
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                throw new SQLServerException(messageFormat.format(new Object[]{object, JDBCType.of(columnMetadata.columnType)}), null, 0, null);
            }
        }
        return objectArray;
    }

    @Override
    public boolean next() throws SQLServerException {
        try {
            this.currentLine = this.fileReader.readLine();
        }
        catch (IOException iOException) {
            throw new SQLServerException(null, iOException.getMessage(), null, 0, false);
        }
        return null != this.currentLine;
    }

    private void throwInvalidArgument(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
    }

    private void checkDuplicateColumnName(int n, String string) throws SQLServerException {
        if (null != string && string.trim().length() != 0) {
            for (Map.Entry<Integer, ColumnMetadata> entry : this.columnMetadata.entrySet()) {
                if (null == entry || entry.getKey() == n || null == entry.getValue() || !string.trim().equalsIgnoreCase(entry.getValue().columnName)) continue;
                throw new SQLServerException(SQLServerException.getErrString("R_BulkCSVDataDuplicateColumn"), null);
            }
        }
    }

    private class ColumnMetadata {
        public String columnName;
        public int columnType;
        public int precision;
        public int scale;

        public ColumnMetadata(String string, int n, int n2, int n3) {
            this.columnName = string;
            this.columnType = n;
            this.precision = n2;
            this.scale = n3;
        }
    }
}

