/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;

public class SQLServerColumnEncryptionJVMKeyStoreProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    static final String KEYSTORE_SUFFIX_FOR_WINDOWS = "\\lib\\security\\cacerts";
    static final String KEYSTORE_SUFFIX_FOR_LINUX = null;
    static final String KEYSTORE_NAME = "MSSQL_JVM_KEYSTORE";
    String keyStorePath = null;
    char[] keyStorePwd = null;
    Map<String, char[]> certificatePasswords = new HashMap<String, char[]>();
    private final String rsaEncryptionAlgorithmWithOAEP = "RSA_OAEP";
    private static final String THUMBPRINT = "Thumbprint";
    private static final String ALIAS = "Alias";
    private byte[] version = new byte[]{1};

    public SQLServerColumnEncryptionJVMKeyStoreProvider(String string, char[] cArray, Map<String, char[]> map) throws SQLServerException {
        this.keyStorePath = null == string ? System.getProperty("java.home").trim() + KEYSTORE_SUFFIX_FOR_WINDOWS : string;
        if (null == cArray) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_KeyStorePwdNull"), null, 0, false);
        }
        this.keyStorePwd = cArray;
        if (null != map) {
            this.certificatePasswords.putAll(map);
        }
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        this.validateMasterKeyDetails(string);
        if (null == byArray) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullEncryptedColumnEncryptionKey"), null, 0, false);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_EmptyEncryptedColumnEncryptionKey"), null, 0, false);
        }
        this.validateEncryptionAlgorithm(string2);
        byte[] byArray2 = new byte[byArray.length];
        CertificateDetails certificateDetails = this.getCertificateDetails(string);
        int n = this.version.length;
        short s = this.convertTwoBytesToShort(byArray, n);
        short s2 = this.convertTwoBytesToShort(byArray, n += 2);
        n += 2;
        int n2 = byArray.length - (n += s) - s2;
        byte[] byArray3 = new byte[s2];
        System.arraycopy(byArray, n, byArray3, 0, s2);
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, n += s2, byArray4, 0, n2);
        byte[] byArray5 = new byte[byArray.length - byArray4.length];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length - byArray4.length);
        if (!this.verifyRSASignature(byArray5, byArray4, certificateDetails.certificate)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidCertificateSignature"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        byArray2 = this.decryptRSAOAEP(byArray3, certificateDetails);
        return byArray2;
    }

    private byte[] decryptRSAOAEP(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, certificateDetails.privateKey);
            cipher.update(byArray);
            byArray2 = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CEKDecryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray2;
    }

    private boolean verifyRSASignature(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate) throws SQLServerException {
        boolean bl = false;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_SignatureVerificationFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return bl;
    }

    private short convertTwoBytesToShort(byte[] byArray, int n) throws SQLServerException {
        short s = -1;
        if (n + 1 >= byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_ByteToShortConversion"), null, 0, false);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[n]);
        byteBuffer.put(byArray[n + 1]);
        s = byteBuffer.getShort(0);
        return s;
    }

    private String getThumbPrint(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return DatatypeConverter.printHexBinary((byte[])byArray2);
    }

    private CertificateDetails getCertificateDetailsByThumbPrint(String string, String string2, KeyStore keyStore) throws SQLServerException {
        try {
            Object[] objectArray;
            Object object = keyStore.aliases();
            while (object.hasMoreElements()) {
                objectArray = object.nextElement();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate((String)objectArray);
                if (!string2.matches(this.getThumbPrint(x509Certificate))) continue;
                Key key = keyStore.getKey((String)objectArray, this.certificatePasswords.get(string));
                if (null == key) {
                    throw new UnrecoverableKeyException();
                }
                return new CertificateDetails(x509Certificate, key);
            }
            object = new MessageFormat(SQLServerException.getErrString("R_CertificateNotFound"));
            objectArray = new Object[]{string2, this.keyStorePath};
            throw new SQLServerException((Object)this, ((Format)object).format(objectArray), null, 0, false);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
            Object[] objectArray = new Object[]{string, generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
    }

    private CertificateDetails getCertificateDetails(String string) throws SQLServerException {
        CertificateDetails certificateDetails;
        block8: {
            String[] stringArray = string.split(":");
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            certificateDetails = null;
            try {
                if (stringArray.length != 2) {
                    throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
                }
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                if (null == this.certificatePasswords.get(string)) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificatePwdNotFound"));
                    Object[] objectArray = new Object[]{string};
                    throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                }
                if (string3.length() == 0 || string2.length() == 0) {
                    throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
                }
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                fileInputStream = new FileInputStream(this.keyStorePath);
                keyStore.load(fileInputStream, this.keyStorePwd);
                if (THUMBPRINT.equalsIgnoreCase(string2)) {
                    certificateDetails = this.getCertificateDetailsByThumbPrint(string, string3, keyStore);
                    break block8;
                }
                if (ALIAS.equalsIgnoreCase(string2)) {
                    certificateDetails = this.getCertificateDetailsByAlias(keyStore, string, string3);
                    break block8;
                }
                throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLServerException((Object)this, SQLServerException.getErrString("R_KeyStoreNotFound"), null, 0, false);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
                Object[] objectArray = new Object[]{string, exception.getMessage()};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
        }
        return certificateDetails;
    }

    private CertificateDetails getCertificateDetailsByAlias(KeyStore keyStore, String string, String string2) throws SQLServerException {
        try {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            Key key = keyStore.getKey(string2, this.certificatePasswords.get(string));
            if (null == x509Certificate) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateNotFoundForAlias"));
                Object[] objectArray = new Object[]{string2, KEYSTORE_NAME};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (null == key) {
                throw new UnrecoverableKeyException();
            }
            return new CertificateDetails(x509Certificate, key);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
            Object[] objectArray = new Object[]{string, generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String string, String string2, byte[] byArray) throws SQLServerException {
        byte[] byArray2;
        this.validateMasterKeyDetails(string);
        if (null == byArray) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullColumnEncryptionKey"), null, 0, false);
        }
        if (0 == byArray.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_EmptyColumnEncryptionKey"), null, 0, false);
        }
        this.validateEncryptionAlgorithm(string2);
        CertificateDetails certificateDetails = this.getCertificateDetails(string);
        byte[] byArray3 = this.encryptRSAOAEP(byArray, certificateDetails);
        byte[] byArray4 = this.getLittleEndianBytesFromShort((short)byArray3.length);
        try {
            byArray2 = string.toLowerCase().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            throw new SQLServerException(messageFormat.format(new Object[]{"UTF-16LE"}), null, 0, null);
        }
        byte[] byArray5 = this.getLittleEndianBytesFromShort((short)byArray2.length);
        byte[] byArray6 = new byte[this.version.length + byArray5.length + byArray4.length + byArray2.length + byArray3.length];
        int n = this.version.length;
        System.arraycopy(this.version, 0, byArray6, 0, this.version.length);
        System.arraycopy(byArray5, 0, byArray6, n, byArray5.length);
        System.arraycopy(byArray4, 0, byArray6, n += byArray5.length, byArray4.length);
        System.arraycopy(byArray2, 0, byArray6, n += byArray4.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, n += byArray2.length, byArray3.length);
        byte[] byArray7 = this.rsaSignHashedData(byArray6, certificateDetails);
        int n2 = this.version.length + byArray4.length + byArray5.length + byArray3.length + byArray2.length + byArray7.length;
        byte[] byArray8 = new byte[n2];
        int n3 = 0;
        System.arraycopy(this.version, 0, byArray8, n3, this.version.length);
        System.arraycopy(byArray5, 0, byArray8, n3 += this.version.length, byArray5.length);
        System.arraycopy(byArray4, 0, byArray8, n3 += byArray5.length, byArray4.length);
        System.arraycopy(byArray2, 0, byArray8, n3 += byArray4.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray8, n3 += byArray2.length, byArray3.length);
        System.arraycopy(byArray7, 0, byArray8, n3 += byArray3.length, byArray7.length);
        return byArray8;
    }

    private byte[] encryptRSAOAEP(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificateDetails.certificate.getPublicKey());
            cipher.update(byArray);
            byArray2 = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray2;
    }

    private byte[] rsaSignHashedData(byte[] byArray, CertificateDetails certificateDetails) throws SQLServerException {
        byte[] byArray2 = null;
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign((PrivateKey)certificateDetails.privateKey);
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] objectArray = new Object[]{generalSecurityException.getMessage()};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        return byArray2;
    }

    private void validateMasterKeyDetails(String string) throws SQLServerException {
        if (null == string || string.trim().length() == 0) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidMasterKeyDetails"), null, 0, false);
        }
    }

    private void validateEncryptionAlgorithm(String string) throws SQLServerException {
        if (null == string) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullKeyEncryptionAlgorithm"), null, 0, false);
        }
        if (!"RSA_OAEP".equalsIgnoreCase(string.trim())) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_InvalidKeyEncryptionAlgorithm"));
            Object[] objectArray = new Object[]{string, "RSA_OAEP"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
    }

    private byte[] getLittleEndianBytesFromShort(short s) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = byteBuffer.putShort(s).array();
        return byArray;
    }

    private class CertificateDetails {
        private X509Certificate certificate;
        private Key privateKey;

        public CertificateDetails(X509Certificate x509Certificate, Key key) {
            this.certificate = x509Certificate;
            this.privateKey = key;
        }
    }
}

