/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionAlgorithmFactoryList;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKeyCache;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SQLServerSecurityUtility {
    SQLServerSecurityUtility() {
    }

    public static byte[] getHMACWithSHA256(byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray3 = new byte[n];
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "HmacSHA256");
        mac.init(secretKeySpec);
        byte[] byArray4 = mac.doFinal(byArray);
        System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
        return byArray3;
    }

    public static boolean compareBytes(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (null == byArray || null == byArray2) {
            return false;
        }
        if (byArray2.length - n < n2) {
            return false;
        }
        for (int i = 0; i < byArray.length && i < n2; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    static byte[] encryptWithKey(byte[] byArray, CryptoMetadata cryptoMetadata, String string) throws SQLServerException {
        assert (string != null) : "Server name should npt be null in EncryptWithKey";
        if (!cryptoMetadata.IsAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(cryptoMetadata, string);
        }
        assert (cryptoMetadata.IsAlgorithmInitialized());
        byte[] byArray2 = cryptoMetadata.cipherAlgorithm.encryptData(byArray);
        if (null == byArray2 || 0 == byArray2.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullCipherTextAE"), null, 0, false);
        }
        return byArray2;
    }

    private static String ValidateAndGetEncryptionAlgorithmName(byte by, String string) throws SQLServerException {
        if (2 != by) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_CustomCipherAlgorithmNotSupportedAE"), null, 0, false);
        }
        return "AEAD_AES_256_CBC_HMAC_SHA256";
    }

    static void decryptSymmetricKey(CryptoMetadata cryptoMetadata, String string) throws SQLServerException {
        Object object;
        assert (null != string) : "serverName should not be null in DecryptSymmetricKey.";
        assert (null != cryptoMetadata) : "md should not be null in DecryptSymmetricKey.";
        assert (null != cryptoMetadata.cekTableEntry) : "md.EncryptionInfo should not be null in DecryptSymmetricKey.";
        assert (null != cryptoMetadata.cekTableEntry.columnEncryptionKeyValues) : "md.EncryptionInfo.ColumnEncryptionKeyValues should not be null in DecryptSymmetricKey.";
        SQLServerSymmetricKey sQLServerSymmetricKey = null;
        EncryptionKeyInfo encryptionKeyInfo = null;
        SQLServerSymmetricKeyCache sQLServerSymmetricKeyCache = SQLServerSymmetricKeyCache.getInstance();
        Iterator<EncryptionKeyInfo> iterator = cryptoMetadata.cekTableEntry.columnEncryptionKeyValues.iterator();
        SQLServerException sQLServerException = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            try {
                sQLServerSymmetricKey = sQLServerSymmetricKeyCache.getKey((EncryptionKeyInfo)object, string);
                if (null == sQLServerSymmetricKey) continue;
                encryptionKeyInfo = object;
                break;
            }
            catch (SQLServerException sQLServerException2) {
                sQLServerException = sQLServerException2;
            }
        }
        if (null == sQLServerSymmetricKey) {
            assert (null != sQLServerException) : "CEK decryption failed without raising exceptions";
            throw sQLServerException;
        }
        cryptoMetadata.cipherAlgorithm = null;
        object = null;
        String string2 = SQLServerSecurityUtility.ValidateAndGetEncryptionAlgorithmName(cryptoMetadata.cipherAlgorithmId, cryptoMetadata.cipherAlgorithmName);
        object = SQLServerEncryptionAlgorithmFactoryList.getInstance().getAlgorithm(sQLServerSymmetricKey, cryptoMetadata.encryptionType, string2);
        assert (null != object) : "Cipher algorithm cannot be null in DecryptSymmetricKey";
        cryptoMetadata.cipherAlgorithm = object;
        cryptoMetadata.encryptionKeyInfo = encryptionKeyInfo;
    }

    static byte[] decryptWithKey(byte[] byArray, CryptoMetadata cryptoMetadata, String string) throws SQLServerException {
        assert (null != string) : "serverName should not be null in DecryptWithKey.";
        if (!cryptoMetadata.IsAlgorithmInitialized()) {
            SQLServerSecurityUtility.decryptSymmetricKey(cryptoMetadata, string);
        }
        assert (cryptoMetadata.IsAlgorithmInitialized()) : "Decryption Algorithm is not initialized";
        byte[] byArray2 = cryptoMetadata.cipherAlgorithm.decryptData(byArray);
        if (null == byArray2) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_PlainTextNullAE"), null, 0, false);
        }
        return byArray2;
    }
}

