/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSParser {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.TOKEN");

    TDSParser() {
    }

    static void parse(TDSReader tDSReader, String string) throws SQLServerException {
        TDSParser.parse(tDSReader, new TDSTokenHandler(string));
    }

    static void parse(TDSReader tDSReader, TDSTokenHandler tDSTokenHandler) throws SQLServerException {
        boolean bl = logger.isLoggable(Level.FINEST);
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        block18: while (bl2) {
            int n = tDSReader.peekTokenType();
            if (bl) {
                logger.finest(tDSReader.toString() + ": " + tDSTokenHandler.logContext + ": Processing " + (-1 == n ? "EOF" : TDS.getTokenName(n)));
            }
            switch (n) {
                case 237: {
                    bl2 = tDSTokenHandler.onSSPI(tDSReader);
                    continue block18;
                }
                case 173: {
                    bl3 = true;
                    bl2 = tDSTokenHandler.onLoginAck(tDSReader);
                    continue block18;
                }
                case 174: {
                    bl4 = true;
                    tDSReader.getConnection().processFeatureExtAck(tDSReader);
                    bl2 = tDSTokenHandler.onFeatureExtensionAck(tDSReader);
                    continue block18;
                }
                case 227: {
                    bl2 = tDSTokenHandler.onEnvChange(tDSReader);
                    continue block18;
                }
                case 121: {
                    bl2 = tDSTokenHandler.onRetStatus(tDSReader);
                    continue block18;
                }
                case 172: {
                    bl2 = tDSTokenHandler.onRetValue(tDSReader);
                    continue block18;
                }
                case 253: 
                case 254: 
                case 255: {
                    tDSReader.getCommand().checkForInterrupt();
                    bl2 = tDSTokenHandler.onDone(tDSReader);
                    continue block18;
                }
                case 170: {
                    bl2 = tDSTokenHandler.onError(tDSReader);
                    continue block18;
                }
                case 171: {
                    bl2 = tDSTokenHandler.onInfo(tDSReader);
                    continue block18;
                }
                case 169: {
                    bl2 = tDSTokenHandler.onOrder(tDSReader);
                    continue block18;
                }
                case 129: {
                    bl2 = tDSTokenHandler.onColMetaData(tDSReader);
                    continue block18;
                }
                case 209: {
                    bl2 = tDSTokenHandler.onRow(tDSReader);
                    continue block18;
                }
                case 210: {
                    bl2 = tDSTokenHandler.onNBCRow(tDSReader);
                    continue block18;
                }
                case 165: {
                    bl2 = tDSTokenHandler.onColInfo(tDSReader);
                    continue block18;
                }
                case 164: {
                    bl2 = tDSTokenHandler.onTabName(tDSReader);
                    continue block18;
                }
                case -1: {
                    tDSReader.getCommand().onTokenEOF();
                    tDSTokenHandler.onEOF(tDSReader);
                    bl2 = false;
                    continue block18;
                }
            }
            TDSParser.throwUnexpectedTokenException(tDSReader, tDSTokenHandler.logContext);
        }
        if (bl3 && !bl4) {
            tDSReader.TryProcessFeatureExtAck(bl4);
        }
    }

    static void throwUnexpectedTokenException(TDSReader tDSReader, String string) throws SQLServerException {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(tDSReader.toString() + ": " + string + ": Encountered unexpected " + TDS.getTokenName(tDSReader.peekTokenType()));
        }
        tDSReader.throwInvalidTDSToken(TDS.getTokenName(tDSReader.peekTokenType()));
    }

    static void ignoreLengthPrefixedToken(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n = tDSReader.readUnsignedShort();
        byte[] byArray = new byte[n];
        tDSReader.readBytes(byArray, 0, n);
    }
}

