/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AsciiFilteredInputStream;
import com.microsoft.sqlserver.jdbc.AsciiFilteredUnicodeInputStream;
import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.GregorianChange;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerNClob;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.UTC;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import microsoft.sql.DateTimeOffset;

final class DDC {
    private static final BigInteger maxRPCDecimalValue = new BigInteger("99999999999999999999999999999999999999");

    DDC() {
    }

    static final Object convertIntegerToObject(int n, int n2, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case INTEGER: {
                return new Integer(n);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)n);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != n);
            }
            case BIGINT: {
                return new Long(n);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Integer.toString(n));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(n);
            }
            case REAL: {
                return new Float(n);
            }
            case BINARY: {
                return DDC.convertIntToBytes(n, n2);
            }
        }
        return Integer.toString(n);
    }

    static final Object convertLongToObject(long l, JDBCType jDBCType, SSType sSType, StreamType streamType) {
        switch (jDBCType) {
            case BIGINT: {
                return new Long(l);
            }
            case INTEGER: {
                return new Integer((int)l);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)l);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0L != l);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Long.toString(l));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(l);
            }
            case REAL: {
                return new Float(l);
            }
            case BINARY: {
                return DDC.convertLongToBytes(l);
            }
            case VARBINARY: {
                switch (sSType) {
                    case BIGINT: {
                        return new Long(l);
                    }
                    case INTEGER: {
                        return new Integer((int)l);
                    }
                    case SMALLINT: 
                    case TINYINT: {
                        return new Short((short)l);
                    }
                    case BIT: {
                        return new Boolean(0L != l);
                    }
                    case DECIMAL: 
                    case NUMERIC: {
                        return new BigDecimal(Long.toString(l));
                    }
                    case FLOAT: {
                        return new Double(l);
                    }
                    case REAL: {
                        return new Float(l);
                    }
                    case BINARY: {
                        return DDC.convertLongToBytes(l);
                    }
                }
                return Long.toString(l);
            }
        }
        return Long.toString(l);
    }

    static final byte[] convertIntToBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = n2;
        while (n3-- > 0) {
            byArray[n3] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    static final Object convertFloatToObject(float f, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case REAL: {
                return new Float(f);
            }
            case INTEGER: {
                return new Integer((int)f);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)f);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != Float.compare(0.0f, f));
            }
            case BIGINT: {
                return new Long((long)f);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Float.toString(f));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(new Float(f).doubleValue());
            }
            case BINARY: {
                return DDC.convertIntToBytes(Float.floatToRawIntBits(f), 4);
            }
        }
        return Float.toString(f);
    }

    static final byte[] convertLongToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 8;
        while (n-- > 0) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    static final Object convertDoubleToObject(double d, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case FLOAT: 
            case DOUBLE: {
                return new Double(d);
            }
            case REAL: {
                return new Float(new Double(d).floatValue());
            }
            case INTEGER: {
                return new Integer((int)d);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)d);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != Double.compare(0.0, d));
            }
            case BIGINT: {
                return new Long((long)d);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Double.toString(d));
            }
            case BINARY: {
                return DDC.convertLongToBytes(Double.doubleToRawLongBits(d));
            }
        }
        return Double.toString(d);
    }

    static final byte[] convertBigDecimalToBytes(BigDecimal bigDecimal, int n) {
        byte[] byArray;
        if (bigDecimal == null) {
            byArray = new byte[]{(byte)n, 0};
        } else {
            boolean bl;
            boolean bl2 = bl = bigDecimal.signum() < 0;
            if (bigDecimal.scale() < 0) {
                bigDecimal = bigDecimal.setScale(0);
            }
            BigInteger bigInteger = bigDecimal.unscaledValue();
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            byte[] byArray2 = bigInteger.toByteArray();
            byArray = new byte[byArray2.length + 3];
            int n2 = 0;
            byArray[n2++] = (byte)bigDecimal.scale();
            byArray[n2++] = (byte)(byArray2.length + 1);
            byArray[n2++] = (byte)(!bl ? 1 : 0);
            for (int i = byArray2.length - 1; i >= 0; --i) {
                byArray[n2++] = byArray2[i];
            }
        }
        return byArray;
    }

    static final Object convertBigDecimalToObject(BigDecimal bigDecimal, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case DECIMAL: 
            case NUMERIC: {
                return bigDecimal;
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(bigDecimal.doubleValue());
            }
            case REAL: {
                return new Float(bigDecimal.floatValue());
            }
            case INTEGER: {
                return new Integer(bigDecimal.intValue());
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short(bigDecimal.shortValue());
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != bigDecimal.compareTo(BigDecimal.valueOf(0L)));
            }
            case BIGINT: {
                return new Long(bigDecimal.longValue());
            }
            case BINARY: {
                return DDC.convertBigDecimalToBytes(bigDecimal, bigDecimal.scale());
            }
        }
        return bigDecimal.toString();
    }

    static final Object convertBytesToObject(byte[] byArray, JDBCType jDBCType, TypeInfo typeInfo) throws SQLServerException {
        switch (jDBCType) {
            case CHAR: {
                String string = Util.bytesToHexString(byArray, byArray.length);
                if (SSType.BINARY == typeInfo.getSSType() && string.length() < typeInfo.getPrecision() * 2) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    while (stringBuffer.length() < typeInfo.getPrecision() * 2) {
                        stringBuffer.append('0');
                    }
                    return stringBuffer.toString();
                }
                return string;
            }
            case BINARY: 
            case VARBINARY: {
                if (SSType.BINARY == typeInfo.getSSType() && byArray.length < typeInfo.getPrecision()) {
                    byte[] byArray2 = new byte[typeInfo.getPrecision()];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    return byArray2;
                }
                return byArray;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getSSType().name(), jDBCType}), null, 0, null);
    }

    static final Object convertStringToObject(String string, String string2, JDBCType jDBCType, StreamType streamType) throws UnsupportedEncodingException, IllegalArgumentException {
        switch (jDBCType) {
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(string.trim());
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.valueOf(string.trim());
            }
            case REAL: {
                return Float.valueOf(string.trim());
            }
            case INTEGER: {
                return Integer.valueOf(string.trim());
            }
            case SMALLINT: 
            case TINYINT: {
                return Short.valueOf(string.trim());
            }
            case BIT: 
            case BOOLEAN: {
                String string3 = string.trim();
                return 1 == string3.length() ? Boolean.valueOf('1' == string3.charAt(0)) : Boolean.valueOf(string3);
            }
            case BIGINT: {
                return Long.valueOf(string.trim());
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(string.trim());
            }
            case DATE: {
                return Date.valueOf(DDC.getDatePart(string.trim()));
            }
            case TIME: {
                Timestamp timestamp = Timestamp.valueOf("1970-01-01 " + DDC.getTimePart(string.trim()));
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(timestamp.getTime());
                if (timestamp.getNanos() % 1000000 >= 500000) {
                    gregorianCalendar.add(14, 1);
                }
                gregorianCalendar.set(1970, 0, 1);
                return new Time(gregorianCalendar.getTimeInMillis());
            }
            case BINARY: {
                return string.getBytes(string2);
            }
        }
        switch (streamType) {
            case CHARACTER: {
                return new StringReader(string);
            }
            case ASCII: {
                return new ByteArrayInputStream(string.getBytes("US-ASCII"));
            }
            case BINARY: {
                return new ByteArrayInputStream(string.getBytes());
            }
        }
        return string;
    }

    static final Object convertStreamToObject(BaseInputStream baseInputStream, TypeInfo typeInfo, JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs) throws SQLServerException {
        if (null == baseInputStream) {
            return null;
        }
        assert (null != typeInfo);
        assert (null != inputStreamGetterArgs);
        SSType sSType = typeInfo.getSSType();
        try {
            switch (jDBCType) {
                default: {
                    if (SSType.BINARY == sSType || SSType.VARBINARY == sSType || SSType.VARBINARYMAX == sSType || SSType.TIMESTAMP == sSType || SSType.IMAGE == sSType || SSType.UDT == sSType) {
                        if (StreamType.ASCII == inputStreamGetterArgs.streamType) {
                            return baseInputStream;
                        }
                        assert (StreamType.CHARACTER == inputStreamGetterArgs.streamType || StreamType.NONE == inputStreamGetterArgs.streamType);
                        byte[] byArray = baseInputStream.getBytes();
                        String string = Util.bytesToHexString(byArray, byArray.length);
                        if (StreamType.NONE == inputStreamGetterArgs.streamType) {
                            return string;
                        }
                        return new StringReader(string);
                    }
                    if (StreamType.ASCII == inputStreamGetterArgs.streamType) {
                        if (typeInfo.supportsFastAsciiConversion()) {
                            return new AsciiFilteredInputStream(baseInputStream);
                        }
                        if (inputStreamGetterArgs.isAdaptive) {
                            return AsciiFilteredUnicodeInputStream.MakeAsciiFilteredUnicodeInputStream(baseInputStream, new BufferedReader(new InputStreamReader((InputStream)baseInputStream, typeInfo.getCharset())));
                        }
                        return new ByteArrayInputStream(new String(baseInputStream.getBytes(), typeInfo.getCharset()).getBytes("US-ASCII"));
                    }
                    if (StreamType.CHARACTER == inputStreamGetterArgs.streamType || StreamType.NCHARACTER == inputStreamGetterArgs.streamType) {
                        if (inputStreamGetterArgs.isAdaptive) {
                            return new BufferedReader(new InputStreamReader((InputStream)baseInputStream, typeInfo.getCharset()));
                        }
                        return new StringReader(new String(baseInputStream.getBytes(), typeInfo.getCharset()));
                    }
                    return DDC.convertStringToObject(new String(baseInputStream.getBytes(), typeInfo.getCharset()), typeInfo.getCharset(), jDBCType, inputStreamGetterArgs.streamType);
                }
                case CLOB: {
                    return new SQLServerClob(baseInputStream, typeInfo);
                }
                case NCLOB: {
                    return new SQLServerNClob(baseInputStream, typeInfo);
                }
                case SQLXML: {
                    return new SQLServerSQLXML(baseInputStream, inputStreamGetterArgs, typeInfo);
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: 
                case BLOB: 
            }
            if (StreamType.BINARY == inputStreamGetterArgs.streamType) {
                return baseInputStream;
            }
            if (JDBCType.BLOB == jDBCType) {
                return new SQLServerBlob(baseInputStream);
            }
            return baseInputStream.getBytes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
            throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getSSType(), jDBCType}), null, 0, (Throwable)illegalArgumentException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
            throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getSSType(), jDBCType}), null, 0, (Throwable)unsupportedEncodingException);
        }
    }

    private static final String getDatePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    private static final String getTimePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String fractionalSecondsString(long l, int n) {
        assert (0L <= l && l < 1000000000L);
        assert (0 <= n && n <= 7);
        if (0 == n) {
            return "";
        }
        return BigDecimal.valueOf(l % 1000000000L, 9).setScale(n).toPlainString().substring(1);
    }

    static final Object convertTemporalToObject(JDBCType jDBCType, SSType sSType, Calendar calendar, int n, long l, int n2) {
        int n3;
        int n4;
        TimeZone timeZone = null != calendar ? calendar.getTimeZone() : TimeZone.getDefault();
        TimeZone timeZone2 = SSType.DATETIMEOFFSET == sSType ? UTC.timeZone : timeZone;
        int n5 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone2, Locale.US);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.clear();
        switch (sSType) {
            case TIME: {
                gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
                gregorianCalendar.set(14, (int)(l / 1000000L));
                n5 = (int)(l % 1000000000L);
                break;
            }
            case DATE: 
            case DATETIME2: 
            case DATETIMEOFFSET: {
                if (n >= GregorianChange.DAYS_SINCE_BASE_DATE_HINT) {
                    gregorianCalendar.set(1, 0, 1 + n + GregorianChange.EXTRA_DAYS_TO_BE_ADDED, 0, 0, 0);
                    gregorianCalendar.set(14, (int)(l / 1000000L));
                } else {
                    gregorianCalendar.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                    gregorianCalendar.set(1, 0, 1 + n, 0, 0, 0);
                    gregorianCalendar.set(14, (int)(l / 1000000L));
                    n4 = gregorianCalendar.get(1);
                    n3 = gregorianCalendar.get(2);
                    int n6 = gregorianCalendar.get(5);
                    int n7 = gregorianCalendar.get(11);
                    int n8 = gregorianCalendar.get(12);
                    int n9 = gregorianCalendar.get(13);
                    int n10 = gregorianCalendar.get(14);
                    gregorianCalendar.setGregorianChange(GregorianChange.STANDARD_CHANGE_DATE);
                    gregorianCalendar.set(n4, n3, n6, n7, n8, n9);
                    gregorianCalendar.set(14, n10);
                }
                if (SSType.DATETIMEOFFSET == sSType && !timeZone2.hasSameRules(timeZone)) {
                    GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone, Locale.US);
                    gregorianCalendar2.clear();
                    gregorianCalendar2.setTimeInMillis(gregorianCalendar.getTimeInMillis());
                    gregorianCalendar = gregorianCalendar2;
                }
                n5 = (int)(l % 1000000000L);
                break;
            }
            case DATETIME: {
                gregorianCalendar.set(1900, 0, 1 + n, 0, 0, 0);
                gregorianCalendar.set(14, (int)l);
                n5 = (int)(l * 1000000L % 1000000000L);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected SSType: " + (Object)((Object)sSType)));
            }
        }
        switch (jDBCType.category) {
            case BINARY: {
                switch (sSType) {
                    case DATE: {
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        return new Date(gregorianCalendar.getTimeInMillis());
                    }
                    case DATETIME2: {
                        Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                        timestamp.setNanos(n5);
                        return timestamp;
                    }
                    case DATETIMEOFFSET: {
                        assert (SSType.DATETIMEOFFSET == sSType);
                        n4 = calendar.get(15);
                        assert (0 == n4 % 60000);
                        Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                        timestamp.setNanos(n5);
                        return DateTimeOffset.valueOf(timestamp, n4 / 60000);
                    }
                    case TIME: {
                        if (n5 % 1000000 >= 500000) {
                            gregorianCalendar.add(14, 1);
                        }
                        gregorianCalendar.set(1970, 0, 1);
                        return new Time(gregorianCalendar.getTimeInMillis());
                    }
                }
                throw new AssertionError((Object)("Unexpected SSType: " + (Object)((Object)sSType)));
            }
            case DATE: {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return new Date(gregorianCalendar.getTimeInMillis());
            }
            case TIME: {
                if (n5 % 1000000 >= 500000) {
                    gregorianCalendar.add(14, 1);
                }
                gregorianCalendar.set(1970, 0, 1);
                return new Time(gregorianCalendar.getTimeInMillis());
            }
            case TIMESTAMP: {
                Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                timestamp.setNanos(n5);
                return timestamp;
            }
            case DATETIMEOFFSET: {
                assert (SSType.DATETIMEOFFSET == sSType);
                n4 = calendar.get(15);
                assert (0 == n4 % 60000);
                Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                timestamp.setNanos(n5);
                return DateTimeOffset.valueOf(timestamp, n4 / 60000);
            }
            case CHARACTER: {
                switch (sSType) {
                    case DATE: {
                        return String.format(Locale.US, "%1$tF", gregorianCalendar);
                    }
                    case TIME: {
                        return String.format(Locale.US, "%1$tT%2$s", gregorianCalendar, DDC.fractionalSecondsString(n5, n2));
                    }
                    case DATETIME2: {
                        return String.format(Locale.US, "%1$tF %1$tT%2$s", gregorianCalendar, DDC.fractionalSecondsString(n5, n2));
                    }
                    case DATETIMEOFFSET: {
                        n4 = calendar.get(15);
                        assert (0 == n4 % 60000);
                        n3 = Math.abs(n4 / 60000);
                        return String.format(Locale.US, "%1$tF %1$tT%2$s %3$c%4$02d:%5$02d", gregorianCalendar, DDC.fractionalSecondsString(n5, n2), Character.valueOf(n4 >= 0 ? (char)'+' : '-'), n3 / 60, n3 % 60);
                    }
                    case DATETIME: {
                        return new Timestamp(gregorianCalendar.getTimeInMillis()).toString();
                    }
                }
                throw new AssertionError((Object)("Unexpected SSType: " + (Object)((Object)sSType)));
            }
        }
        throw new AssertionError((Object)("Unexpected JDBCType: " + (Object)((Object)jDBCType)));
    }

    static int daysSinceBaseDate(int n, int n2, int n3) {
        assert (n >= 1);
        assert (n3 >= 1);
        assert (n2 >= 1);
        return n2 - 1 + (n - n3) * 365 + DDC.leapDaysBeforeYear(n) - DDC.leapDaysBeforeYear(n3);
    }

    private static int leapDaysBeforeYear(int n) {
        assert (n >= 1);
        return (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400;
    }

    static final boolean exceedsMaxRPCDecimalPrecisionOrScale(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        if (null == bigDecimal) {
            return false;
        }
        if (bigDecimal.scale() > 38) {
            return true;
        }
        BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
        if (bigDecimal.signum() < 0) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger.compareTo(maxRPCDecimalValue) > 0;
    }

    static String convertReaderToString(Reader reader, int n) throws SQLServerException {
        assert (-1 == n || n >= 0);
        if (null == reader) {
            return null;
        }
        if (0 == n) {
            return "";
        }
        try {
            int n2;
            StringBuilder stringBuilder = new StringBuilder(-1 != n ? n : 4000);
            char[] cArray = new char[-1 != n && n < 4000 ? n : 4000];
            while ((n2 = reader.read(cArray, 0, cArray.length)) > 0) {
                if (n2 > cArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                }
                stringBuilder.append(cArray, 0, n2);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
            Object[] objectArray = new Object[]{iOException.toString()};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
            return null;
        }
    }
}

