/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import microsoft.sql.DateTimeOffset;

final class Parameter {
    private TypeInfo typeInfo;
    CryptoMetadata cryptoMeta = null;
    private String typeDefinition = null;
    private JDBCType jdbcTypeSetByUser = null;
    private int valueLength = 0;
    private int outScale = 4;
    private String name;
    private DTV getterDTV;
    private DTV registeredOutDTV = null;
    private DTV setterDTV = null;
    private DTV inputDTV = null;

    Parameter() {
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    final CryptoMetadata getCryptoMetadata() {
        return this.cryptoMeta;
    }

    boolean isOutput() {
        return null != this.registeredOutDTV;
    }

    JDBCType getJdbcType() throws SQLServerException {
        return null != this.inputDTV ? this.inputDTV.getJdbcType() : JDBCType.UNKNOWN;
    }

    private static JDBCType getSSPAUJDBCType(JDBCType jDBCType) {
        switch (jDBCType) {
            case CHAR: {
                return JDBCType.NCHAR;
            }
            case VARCHAR: {
                return JDBCType.NVARCHAR;
            }
            case LONGVARCHAR: {
                return JDBCType.LONGNVARCHAR;
            }
            case CLOB: {
                return JDBCType.NCLOB;
            }
        }
        return jDBCType;
    }

    void registerForOutput(JDBCType jDBCType, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (JDBCType.DATETIMEOFFSET == jDBCType && !sQLServerConnection.isKatmaiOrLater()) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (sQLServerConnection.sendStringParametersAsUnicode()) {
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        this.registeredOutDTV = new DTV();
        this.registeredOutDTV.setJdbcType(jDBCType);
        if (null == this.setterDTV) {
            this.inputDTV = this.registeredOutDTV;
        }
        this.resetOutputValue();
    }

    int getOutScale() {
        return this.outScale;
    }

    void setOutScale(int n) {
        this.outScale = n;
    }

    final Parameter cloneForBatch() {
        Parameter parameter = new Parameter();
        parameter.typeInfo = this.typeInfo;
        parameter.typeDefinition = this.typeDefinition;
        parameter.outScale = this.outScale;
        parameter.name = this.name;
        parameter.getterDTV = this.getterDTV;
        parameter.registeredOutDTV = this.registeredOutDTV;
        parameter.setterDTV = this.setterDTV;
        parameter.inputDTV = this.inputDTV;
        parameter.cryptoMeta = this.cryptoMeta;
        parameter.jdbcTypeSetByUser = this.jdbcTypeSetByUser;
        parameter.valueLength = this.valueLength;
        return parameter;
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    final void skipRetValStatus(TDSReader tDSReader) throws SQLServerException {
        StreamRetValue streamRetValue = new StreamRetValue();
        streamRetValue.setFromTDS(tDSReader);
    }

    void clearInputValue() {
        this.setterDTV = null;
        this.inputDTV = this.registeredOutDTV;
    }

    void resetOutputValue() {
        this.getterDTV = null;
        this.typeInfo = null;
    }

    void deriveTypeInfo(TDSReader tDSReader) throws SQLServerException {
        if (null == this.typeInfo) {
            this.typeInfo = TypeInfo.getInstance(tDSReader, true);
        }
    }

    void setFromReturnStatus(int n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.getterDTV.setValue(null, JDBCType.INTEGER, new Integer(n), JavaType.INTEGER, null, null, null, sQLServerConnection);
    }

    void setValue(JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (!(JDBCType.DATETIMEOFFSET != jDBCType && JavaType.DATETIMEOFFSET != javaType || sQLServerConnection.isKatmaiOrLater())) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (sQLServerConnection.isColumnEncryptionSettingEnabled()) {
            this.setJdbcTypeSetByUser(jDBCType);
            switch (javaType) {
                case STRING: {
                    this.setValueLength(((String)object).length());
                    break;
                }
                case BYTEARRAY: {
                    this.setValueLength(((byte[])object).length);
                    break;
                }
                case BIGDECIMAL: {
                    this.setValueLength(((BigDecimal)object).precision());
                }
            }
        }
        if (sQLServerConnection.sendStringParametersAsUnicode() && (JavaType.STRING == javaType || JavaType.READER == javaType || JavaType.CLOB == javaType)) {
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        DTV dTV = new DTV();
        dTV.setValue(sQLServerConnection.getDatabaseCollation(), jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection);
        this.inputDTV = this.setterDTV = dTV;
    }

    boolean isNull() {
        if (null != this.getterDTV) {
            return this.getterDTV.isNull();
        }
        return false;
    }

    boolean isValueGotten() {
        return null != this.getterDTV;
    }

    Object getValue(JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.getterDTV.getValue(jDBCType, this.outScale, inputStreamGetterArgs, calendar, this.typeInfo, this.cryptoMeta, tDSReader);
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        Integer n = (Integer)this.getValue(JDBCType.INTEGER, null, null, tDSReader);
        return null != n ? n : 0;
    }

    String getTypeDefinition(SQLServerConnection sQLServerConnection, TDSReader tDSReader) throws SQLServerException {
        if (null == this.inputDTV) {
            return null;
        }
        this.inputDTV.executeOp(new GetTypeDefinitionOp(this, sQLServerConnection));
        return this.typeDefinition;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        assert (null != this.inputDTV) : "Parameter was neither set nor registered";
        try {
            this.inputDTV.sendCryptoMetaData(this.cryptoMeta, tDSWriter);
            this.inputDTV.jdbcTypeSetByUser(this.getJdbcTypeSetByUser(), this.getValueLength());
            this.inputDTV.sendByRPC(this.name, null, sQLServerConnection.getDatabaseCollation(), this.outScale, this.isOutput(), tDSWriter, sQLServerConnection);
        }
        finally {
            this.inputDTV.sendCryptoMetaData(null, tDSWriter);
        }
        if (JavaType.INPUTSTREAM == this.inputDTV.getJavaType() || JavaType.READER == this.inputDTV.getJavaType()) {
            this.setterDTV = null;
            this.inputDTV = null;
        }
    }

    public JDBCType getJdbcTypeSetByUser() {
        return this.jdbcTypeSetByUser;
    }

    public void setJdbcTypeSetByUser(JDBCType jDBCType) {
        this.jdbcTypeSetByUser = jDBCType;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int n) {
        this.valueLength = n;
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private static final String NVARCHAR_MAX = "nvarchar(max)";
        private static final String NVARCHAR_4K = "nvarchar(4000)";
        private static final String NTEXT = "ntext";
        private static final String VARCHAR_MAX = "varchar(max)";
        private static final String VARCHAR_8K = "varchar(8000)";
        private static final String TEXT = "text";
        private static final String VARBINARY_MAX = "varbinary(max)";
        private static final String VARBINARY_8K = "varbinary(8000)";
        private static final String IMAGE = "image";
        private final Parameter param;
        private final SQLServerConnection con;
        int scale = 0;

        GetTypeDefinitionOp(Parameter parameter2, SQLServerConnection sQLServerConnection) {
            this.param = parameter2;
            this.con = sQLServerConnection;
        }

        private void setTypeDefinition(DTV dTV) {
            switch (dTV.getJdbcType()) {
                case TINYINT: {
                    this.param.typeDefinition = SSType.TINYINT.toString();
                    break;
                }
                case SMALLINT: {
                    this.param.typeDefinition = SSType.SMALLINT.toString();
                    break;
                }
                case INTEGER: {
                    this.param.typeDefinition = SSType.INTEGER.toString();
                    break;
                }
                case BIGINT: {
                    this.param.typeDefinition = SSType.BIGINT.toString();
                    break;
                }
                case REAL: {
                    if (this.con.isColumnEncryptionSettingEnabled() && null != Parameter.this.jdbcTypeSetByUser) {
                        this.param.typeDefinition = SSType.REAL.toString();
                        break;
                    }
                }
                case FLOAT: 
                case DOUBLE: {
                    this.param.typeDefinition = SSType.FLOAT.toString();
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    Integer n;
                    if (this.scale > 38) {
                        this.scale = 38;
                    }
                    if (null != (n = dTV.getScale()) && this.scale < n) {
                        this.scale = n;
                    }
                    if (this.param.isOutput() && this.scale < this.param.getOutScale()) {
                        this.scale = this.param.getOutScale();
                    }
                    if (this.con.isColumnEncryptionSettingEnabled() && null != Parameter.this.jdbcTypeSetByUser) {
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "decimal";
                            break;
                        }
                        this.param.typeDefinition = "decimal(" + Parameter.this.valueLength + "," + this.scale + ")";
                        break;
                    }
                    this.param.typeDefinition = "decimal(38," + this.scale + ")";
                    break;
                }
                case BIT: 
                case BOOLEAN: {
                    this.param.typeDefinition = SSType.BIT.toString();
                    break;
                }
                case LONGVARBINARY: 
                case BLOB: {
                    this.param.typeDefinition = VARBINARY_MAX;
                    break;
                }
                case BINARY: 
                case VARBINARY: {
                    if (VARBINARY_MAX == this.param.typeDefinition || IMAGE == this.param.typeDefinition) break;
                    if (this.con.isColumnEncryptionSettingEnabled() && null != Parameter.this.jdbcTypeSetByUser) {
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "varbinary";
                            break;
                        }
                        this.param.typeDefinition = "varbinary(" + Parameter.this.valueLength + ")";
                        break;
                    }
                    this.param.typeDefinition = VARBINARY_8K;
                    break;
                }
                case DATE: {
                    this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATE.toString() : SSType.DATETIME.toString();
                    break;
                }
                case TIME: {
                    this.param.typeDefinition = this.con.sendTimeAsDatetime() ? SSType.DATETIME.toString() : SSType.TIME.toString();
                    break;
                }
                case TIMESTAMP: {
                    this.param.typeDefinition = this.con.isKatmaiOrLater() ? SSType.DATETIME2.toString() : SSType.DATETIME.toString();
                    break;
                }
                case TIME_WITH_TIMEZONE: 
                case TIMESTAMP_WITH_TIMEZONE: 
                case DATETIMEOFFSET: {
                    this.param.typeDefinition = SSType.DATETIMEOFFSET.toString();
                    break;
                }
                case LONGVARCHAR: 
                case CLOB: {
                    this.param.typeDefinition = VARCHAR_MAX;
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    if (VARCHAR_MAX == this.param.typeDefinition || TEXT == this.param.typeDefinition) break;
                    if (this.con.isColumnEncryptionSettingEnabled() && null != Parameter.this.jdbcTypeSetByUser) {
                        if (0 == Parameter.this.valueLength) {
                            this.param.typeDefinition = "varchar";
                            break;
                        }
                        this.param.typeDefinition = "varchar(" + Parameter.this.valueLength + ")";
                        break;
                    }
                    this.param.typeDefinition = VARCHAR_8K;
                    break;
                }
                case LONGNVARCHAR: 
                case NCLOB: {
                    if (this.con.isColumnEncryptionSettingEnabled()) {
                        if (null != Parameter.this.jdbcTypeSetByUser && Parameter.this.jdbcTypeSetByUser == JDBCType.VARCHAR) {
                            this.param.typeDefinition = "varchar";
                            break;
                        }
                        if (null != Parameter.this.jdbcTypeSetByUser && Parameter.this.jdbcTypeSetByUser == JDBCType.NVARCHAR) {
                            this.param.typeDefinition = "nvarchar";
                            break;
                        }
                        this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                        break;
                    }
                    this.param.typeDefinition = NVARCHAR_MAX;
                    break;
                }
                case NCHAR: 
                case NVARCHAR: {
                    if (NVARCHAR_MAX == this.param.typeDefinition || NTEXT == this.param.typeDefinition) break;
                    if (this.con.isColumnEncryptionSettingEnabled()) {
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.VARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.CHAR)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "varchar";
                                break;
                            }
                            this.param.typeDefinition = "varchar(" + Parameter.this.valueLength + ")";
                            break;
                        }
                        if (null != Parameter.this.jdbcTypeSetByUser && (Parameter.this.jdbcTypeSetByUser == JDBCType.NVARCHAR || Parameter.this.jdbcTypeSetByUser == JDBCType.NCHAR)) {
                            if (0 == Parameter.this.valueLength) {
                                this.param.typeDefinition = "nvarchar";
                                break;
                            }
                            this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                            break;
                        }
                        this.param.typeDefinition = "nvarchar(" + Parameter.this.valueLength + ")";
                        break;
                    }
                    this.param.typeDefinition = NVARCHAR_4K;
                    break;
                }
                case SQLXML: {
                    this.param.typeDefinition = SSType.XML.toString();
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBC type " + (Object)((Object)dTV.getJdbcType());
                    break;
                }
            }
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            if (null != string && string.length() > 4000) {
                dTV.setJdbcType(JDBCType.LONGNVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, java.util.Date date) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Calendar calendar) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalDate localDate) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalTime localTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, LocalDateTime localDateTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, OffsetTime offsetTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, OffsetDateTime offsetDateTime) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
            this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
            this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (null != bigDecimal) {
                this.scale = bigDecimal.scale();
                if (this.scale < 0) {
                    this.scale = 0;
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, BigInteger bigInteger) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            if (null != byArray && byArray.length > 8000) {
                dTV.setJdbcType(dTV.getJdbcType().isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
            JDBCType jDBCType = dTV.getJdbcType();
            if (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.BINARY == jDBCType || JDBCType.VARBINARY == jDBCType) {
                if (streamSetterArgs.getLength() > 8000L) {
                    dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    byte[] byArray = new byte[8001];
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, byArray.length);
                    int n = 0;
                    try {
                        bufferedInputStream.mark(byArray.length);
                        n = bufferedInputStream.read(byArray, 0, byArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedInputStream.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedInputStream, JavaType.INPUTSTREAM);
                    if (n > 8000) {
                        dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            if (JDBCType.NCHAR == dTV.getJdbcType() || JDBCType.NVARCHAR == dTV.getJdbcType()) {
                StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
                if (streamSetterArgs.getLength() > 4000L) {
                    dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    char[] cArray = new char[4001];
                    BufferedReader bufferedReader = new BufferedReader(reader, cArray.length);
                    int n = 0;
                    try {
                        bufferedReader.mark(cArray.length);
                        n = bufferedReader.read(cArray, 0, cArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedReader.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedReader, JavaType.READER);
                    if (n > 4000) {
                        dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }
    }
}

