/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.ZeroFixupFilter;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQLServerParameterMetaData
implements ParameterMetaData {
    private static final int SQL_SERVER_2012_VERSION = 11;
    private final SQLServerStatement stmtParent;
    private SQLServerConnection con;
    private Statement stmtCall;
    private SQLServerResultSet rsProcedureMeta;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerParameterMetaData");
    private static int baseID = 0;
    private final String traceID = " SQLServerParameterMetaData:" + SQLServerParameterMetaData.nextInstanceID();
    Map<Integer, QueryMeta> queryMetaMap = null;

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    private String parseColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =?<>!", true);
        int n = 0;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5 = stringTokenizer.nextToken();
            if (string5.equalsIgnoreCase(string2)) {
                n = 1;
                continue;
            }
            if (n == 0) continue;
            if (string5.charAt(0) == '=' || string5.equalsIgnoreCase("is") || string5.charAt(0) == '<' || string5.charAt(0) == '>' || string5.equalsIgnoreCase("like") || string5.equalsIgnoreCase("not") || string5.equalsIgnoreCase("in") || string5.charAt(0) == '!') {
                n = 2;
                continue;
            }
            if (string5.charAt(0) == '?' && string3 != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string3);
                n = 1;
                string3 = null;
                continue;
            }
            if (n != 1 || string5.equals(" ") || (string4 = this.escapeParse(stringTokenizer, string5)).length() <= 0) continue;
            string3 = string4;
        }
        return stringBuilder.toString();
    }

    private String parseInsertColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " (),", true);
        int n = 0;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase(string2)) {
                n = 1;
                continue;
            }
            if (n == 0) continue;
            if (string4.charAt(0) == '=') {
                n = 2;
                continue;
            }
            if ((string4.charAt(0) == ',' || string4.charAt(0) == ')' || string4.charAt(0) == ' ') && string3 != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string3);
                n = 1;
                string3 = null;
            }
            if (string4.charAt(0) == ')') {
                n = 0;
                break;
            }
            if (n != 1 || string4.trim().length() <= 0 || string4.charAt(0) == ',') continue;
            string3 = this.escapeParse(stringTokenizer, string4);
        }
        return stringBuilder.toString();
    }

    private void parseQueryMeta(ResultSet resultSet) throws SQLServerException {
        Pattern pattern = Pattern.compile("(.*)\\((.*)(\\)|,(.*)\\))");
        try {
            while (resultSet.next()) {
                SSType sSType;
                QueryMeta queryMeta = new QueryMeta();
                int n = resultSet.getInt("parameter_ordinal");
                String string = resultSet.getString("suggested_system_type_name");
                queryMeta.precision = resultSet.getInt("suggested_precision");
                queryMeta.scale = resultSet.getInt("suggested_scale");
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    sSType = SSType.of(matcher.group(1));
                    if (string.equalsIgnoreCase("varchar(max)") || string.equalsIgnoreCase("varbinary(max)")) {
                        queryMeta.precision = Integer.MAX_VALUE;
                    } else if (string.equalsIgnoreCase("nvarchar(max)")) {
                        queryMeta.precision = 0x3FFFFFFF;
                    } else if (SSType.Category.CHARACTER == sSType.category || SSType.Category.BINARY == sSType.category || SSType.Category.NCHARACTER == sSType.category) {
                        try {
                            queryMeta.precision = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
                            Object[] objectArray = new Object[]{new Integer(n)};
                            SQLServerException.makeFromDriverError(this.con, this.stmtParent, messageFormat.format(objectArray) + " " + numberFormatException.toString(), null, false);
                        }
                    }
                } else {
                    sSType = SSType.of(string);
                }
                if (SSType.FLOAT == sSType) {
                    queryMeta.precision = 15;
                } else if (SSType.REAL == sSType) {
                    queryMeta.precision = 7;
                }
                JDBCType jDBCType = sSType.getJDBCType();
                queryMeta.parameterClassName = jDBCType.className();
                queryMeta.parameterType = jDBCType.getIntValue();
                queryMeta.parameterTypeName = sSType.name();
                queryMeta.isSigned = SSType.Category.NUMERIC == sSType.category && SSType.BIT != sSType;
                this.queryMetaMap.put(n, queryMeta);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), sQLException);
        }
    }

    private void parseQueryMetaFor2008(ResultSet resultSet) throws SQLServerException {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                QueryMeta queryMeta = new QueryMeta();
                queryMeta.parameterClassName = resultSetMetaData.getColumnClassName(i);
                queryMeta.parameterType = resultSetMetaData.getColumnType(i);
                queryMeta.parameterTypeName = resultSetMetaData.getColumnTypeName(i);
                queryMeta.precision = resultSetMetaData.getPrecision(i);
                queryMeta.scale = resultSetMetaData.getScale(i);
                queryMeta.isNullable = resultSetMetaData.isNullable(i);
                queryMeta.isSigned = resultSetMetaData.isSigned(i);
                this.queryMetaMap.put(i, queryMeta);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), sQLException);
        }
    }

    private String escapeParse(StringTokenizer stringTokenizer, String string) {
        String string2 = string;
        while (string2.equals(" ") && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = string2;
        if (string2.charAt(0) == '[' && string2.charAt(string2.length() - 1) != ']') {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string3 = string3.concat(string2);
                if (string2.charAt(string2.length() - 1) != ']') continue;
            }
        }
        string3 = string3.trim();
        return string3;
    }

    private MetaInfo parseStatement(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", true);
        String string3 = null;
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().trim();
            if (!string5.equalsIgnoreCase(string2) || !stringTokenizer.hasMoreTokens()) continue;
            string3 = this.escapeParse(stringTokenizer, stringTokenizer.nextToken());
            break;
        }
        if (null != string3) {
            string4 = string2.equalsIgnoreCase("UPDATE") ? this.parseColumns(string, "SET") : (string2.equalsIgnoreCase("INTO") ? this.parseInsertColumns(string, "(") : this.parseColumns(string, "WHERE"));
            return new MetaInfo(string3, string4);
        }
        return null;
    }

    private MetaInfo parseStatement(String string) throws SQLServerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("INSERT")) {
                return this.parseStatement(string, "INTO");
            }
            if (string2.equalsIgnoreCase("UPDATE")) {
                return this.parseStatement(string, "UPDATE");
            }
            if (string2.equalsIgnoreCase("SELECT")) {
                return this.parseStatement(string, "FROM");
            }
            if (string2.equalsIgnoreCase("DELETE")) {
                return this.parseStatement(string, "FROM");
            }
        }
        return null;
    }

    String parseThreePartNames(String string) throws SQLServerException {
        CharSequence charSequence;
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        block10: while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            String string5 = this.escapeParse(stringTokenizer, (String)charSequence);
            if (string5.equals(".")) continue;
            switch (n) {
                case 2: {
                    string4 = string3;
                    string3 = string2;
                    string2 = string5;
                    ++n;
                    continue block10;
                }
                case 1: {
                    string3 = string2;
                    string2 = string5;
                    ++n;
                    continue block10;
                }
                case 0: {
                    string2 = string5;
                    ++n;
                    continue block10;
                }
            }
            ++n;
        }
        charSequence = new StringBuilder(100);
        if (n > 3 && 1 < n) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
        switch (n) {
            case 3: {
                ((StringBuilder)charSequence).append("@procedure_qualifier =");
                ((StringBuilder)charSequence).append(string4);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append("@procedure_owner =");
                ((StringBuilder)charSequence).append(string3);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append("@procedure_name =");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(", ");
                break;
            }
            case 2: {
                ((StringBuilder)charSequence).append("@procedure_owner =");
                ((StringBuilder)charSequence).append(string3);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append("@procedure_name =");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(", ");
                break;
            }
            case 1: {
                ((StringBuilder)charSequence).append("@procedure_name =");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(", ");
                break;
            }
        }
        return ((StringBuilder)charSequence).toString();
    }

    private void checkClosed() throws SQLServerException {
        this.stmtParent.checkClosed();
    }

    SQLServerParameterMetaData(SQLServerStatement sQLServerStatement, String string) throws SQLServerException {
        assert (null != sQLServerStatement);
        this.stmtParent = sQLServerStatement;
        this.con = sQLServerStatement.connection;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerStatement.toString() + ")");
        }
        try {
            if (null != sQLServerStatement.procedureName) {
                SQLServerStatement sQLServerStatement2 = (SQLServerStatement)this.con.createStatement(1004, 1007);
                String string2 = this.parseThreePartNames(sQLServerStatement.procedureName);
                this.rsProcedureMeta = this.con.isKatmaiOrLater() ? sQLServerStatement2.executeQueryInternal("exec sp_sproc_columns_100 " + string2 + " @ODBCVer=3") : sQLServerStatement2.executeQueryInternal("exec sp_sproc_columns " + string2 + " @ODBCVer=3");
                this.rsProcedureMeta.getColumn(6).setFilter(new DataTypeFilter());
                if (this.con.isKatmaiOrLater()) {
                    this.rsProcedureMeta.getColumn(8).setFilter(new ZeroFixupFilter());
                    this.rsProcedureMeta.getColumn(9).setFilter(new ZeroFixupFilter());
                    this.rsProcedureMeta.getColumn(17).setFilter(new ZeroFixupFilter());
                }
            } else {
                this.queryMetaMap = new HashMap<Integer, QueryMeta>();
                if (this.con.getServerMajorVersion() >= 11) {
                    String string3 = this.con.replaceParameterMarkers(((SQLServerPreparedStatement)this.stmtParent).userSQL, ((SQLServerPreparedStatement)this.stmtParent).inOutParam, ((SQLServerPreparedStatement)this.stmtParent).bReturnValueSyntax);
                    String string4 = "exec sp_describe_undeclared_parameters @tsql = N'" + string3 + "'";
                    this.parseQueryMeta(this.con.prepareCall(string4).executeQuery());
                } else {
                    Object object;
                    Object object2;
                    MetaInfo metaInfo = this.parseStatement(string);
                    if (null == metaInfo) {
                        object2 = new MessageFormat(SQLServerException.getErrString("R_cantIdentifyTableMetadata"));
                        object = new Object[]{new String(string)};
                        SQLServerException.makeFromDriverError(this.con, this.stmtParent, ((Format)object2).format(object), null, false);
                    }
                    if (metaInfo.fields.length() <= 0) {
                        return;
                    }
                    object2 = this.con.createStatement();
                    object = "sp_executesql N'SET FMTONLY ON SELECT " + metaInfo.fields + " FROM " + metaInfo.table + " WHERE 1 = 2'";
                    ResultSet resultSet = object2.executeQuery((String)object);
                    this.parseQueryMetaFor2008(resultSet);
                }
            }
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    private void verifyParameterPosition(int n) throws SQLServerException {
        Object[] objectArray;
        boolean bl = false;
        try {
            bl = this.rsProcedureMeta.absolute(n + 1);
        }
        catch (SQLException sQLException) {
            objectArray = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
            Object[] objectArray2 = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, objectArray.format(objectArray2) + " " + sQLException.toString(), null, false);
        }
        if (!bl) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, messageFormat.format(objectArray), null, false);
        }
    }

    private void checkParam(int n) throws SQLServerException {
        if (!this.queryMetaMap.containsKey(n)) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).parameterClassName;
            }
            this.verifyParameterPosition(n);
            JDBCType jDBCType = JDBCType.of(this.rsProcedureMeta.getShort("DATA_TYPE"));
            return jDBCType.className();
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return null;
        }
    }

    @Override
    public int getParameterCount() throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                return this.queryMetaMap.size();
            }
            this.rsProcedureMeta.last();
            int n = this.rsProcedureMeta.getRow() - 1;
            if (n < 0) {
                n = 0;
            }
            return n;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getParameterMode(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return 1;
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("COLUMN_TYPE");
            switch (n2) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getParameterType(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).parameterType;
            }
            this.verifyParameterPosition(n);
            short s = this.rsProcedureMeta.getShort("DATA_TYPE");
            return s;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public String getParameterTypeName(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).parameterTypeName;
            }
            this.verifyParameterPosition(n);
            return this.rsProcedureMeta.getString("TYPE_NAME");
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return null;
        }
    }

    @Override
    public int getPrecision(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).precision;
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("PRECISION");
            return n2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getScale(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).scale;
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("SCALE");
            return n2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int isNullable(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).isNullable;
            }
            this.verifyParameterPosition(n);
            int n2 = this.rsProcedureMeta.getInt("NULLABLE");
            if (n2 == 1) {
                return 1;
            }
            if (n2 == 0) {
                return 0;
            }
            return 2;
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return 0;
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(n);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)n)).isSigned;
            }
            this.verifyParameterPosition(n);
            return JDBCType.of(this.rsProcedureMeta.getShort("DATA_TYPE")).isSigned();
        }
        catch (SQLException sQLException) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, sQLException.toString(), null, false);
            return false;
        }
    }

    private class MetaInfo {
        String table;
        String fields;

        MetaInfo(String string, String string2) {
            this.table = string;
            this.fields = string2;
        }
    }

    class QueryMeta {
        String parameterClassName = null;
        int parameterType = 0;
        String parameterTypeName = null;
        int precision = 0;
        int scale = 0;
        int isNullable = 2;
        boolean isSigned = false;

        QueryMeta() {
        }
    }
}

