/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

final class SQLServerSymmetricKeyCache {
    private final ConcurrentHashMap<String, SQLServerSymmetricKey> cache = new ConcurrentHashMap();
    private static final SQLServerSymmetricKeyCache instance = new SQLServerSymmetricKeyCache();

    private SQLServerSymmetricKeyCache() {
    }

    static SQLServerSymmetricKeyCache getInstance() {
        return instance;
    }

    SQLServerSymmetricKey getKey(EncryptionKeyInfo encryptionKeyInfo, String string) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = null;
        SQLServerSymmetricKey sQLServerSymmetricKey = null;
        stringBuffer.append(":");
        try {
            stringBuffer.append(new String(encryptionKeyInfo.encryptedKey, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            Object[] objectArray = new Object[]{"UTF-8"};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        stringBuffer.append(":");
        stringBuffer.append(encryptionKeyInfo.keyStoreName);
        string2 = stringBuffer.toString();
        Boolean[] booleanArray = new Boolean[1];
        List<String> list = SQLServerConnection.getColumnEncryptionTrustedMasterKeyPaths(string, booleanArray);
        if (booleanArray[0].booleanValue() && (null == list || 0 == list.size() || !list.contains(encryptionKeyInfo.keyPath))) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UntrustedKeyPath"));
            Object[] objectArray = new Object[]{encryptionKeyInfo.keyPath, string};
            throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
        }
        if (!this.cache.containsKey(string2)) {
            SQLServerColumnEncryptionKeyStoreProvider sQLServerColumnEncryptionKeyStoreProvider = SQLServerConnection.getColumnEncryptionKeyStoreProvider(encryptionKeyInfo.keyStoreName);
            if (null == sQLServerColumnEncryptionKeyStoreProvider) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecognizedKeyStoreProviderName"));
                Object[] objectArray = new Object[]{encryptionKeyInfo.keyStoreName};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            byte[] byArray = sQLServerColumnEncryptionKeyStoreProvider.decryptColumnEncryptionKey(encryptionKeyInfo.keyPath, encryptionKeyInfo.algorithmName, encryptionKeyInfo.encryptedKey);
            sQLServerSymmetricKey = new SQLServerSymmetricKey(byArray);
            this.cache.putIfAbsent(string2, sQLServerSymmetricKey);
        }
        sQLServerSymmetricKey = this.cache.get(string2);
        return sQLServerSymmetricKey;
    }
}

