/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Encoding;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSLenType;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.UDTTDSHeader;
import com.microsoft.sqlserver.jdbc.XMLTDSHeader;
import java.util.EnumMap;
import java.util.Map;

final class TypeInfo {
    private int maxLength;
    private SSLenType ssLenType;
    private int precision;
    private int displaySize;
    private int scale;
    private short flags;
    private SSType ssType;
    private int userType;
    private String udtTypeName;
    private SQLCollation collation;
    private String charset;
    static int UPDATABLE_READ_ONLY = 0;
    static int UPDATABLE_READ_WRITE = 1;
    static int UPDATABLE_UNKNOWN = 2;
    private static final Map<TDSType, Builder> builderMap = new EnumMap<TDSType, Builder>(TDSType.class);

    SSType getSSType() {
        return this.ssType;
    }

    SSLenType getSSLenType() {
        return this.ssLenType;
    }

    String getSSTypeName() {
        return SSType.UDT == this.ssType ? this.udtTypeName : this.ssType.toString();
    }

    int getMaxLength() {
        return this.maxLength;
    }

    int getPrecision() {
        return this.precision;
    }

    int getDisplaySize() {
        return this.displaySize;
    }

    int getScale() {
        return this.scale;
    }

    SQLCollation getSQLCollation() {
        return this.collation;
    }

    String getCharset() {
        return this.charset;
    }

    boolean isNullable() {
        return 1 == (this.flags & 1);
    }

    boolean isCaseSensitive() {
        return 2 == (this.flags & 2);
    }

    boolean isSparseColumnSet() {
        return 1024 == (this.flags & 0x400);
    }

    boolean isEncrypted() {
        return 2048 == (this.flags & 0x800);
    }

    int getUpdatability() {
        return this.flags >> 2 & 3;
    }

    boolean isIdentity() {
        return 16 == (this.flags & 0x10);
    }

    byte[] getFlags() {
        byte[] byArray = new byte[]{(byte)(this.flags & 0xFF), (byte)(this.flags >> 8 & 0xFF)};
        return byArray;
    }

    boolean supportsFastAsciiConversion() {
        switch (this.ssType) {
            case CHAR: 
            case VARCHAR: 
            case VARCHARMAX: 
            case TEXT: {
                return this.collation.hasAsciiCompatibleSBCS();
            }
        }
        return false;
    }

    private TypeInfo() {
    }

    static TypeInfo getInstance(TDSReader tDSReader, boolean bl) throws SQLServerException {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.userType = tDSReader.readInt();
        if (bl) {
            typeInfo.flags = tDSReader.readShort();
        }
        TDSType tDSType = null;
        try {
            tDSType = TDSType.valueOf(tDSReader.readUnsignedByte());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            tDSReader.getConnection().terminate(4, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        assert (null != builderMap.get((Object)tDSType)) : "Missing TypeInfo builder for TDSType " + (Object)((Object)tDSType);
        return builderMap.get((Object)tDSType).build(typeInfo, tDSReader);
    }

    static {
        for (Builder builder : Builder.values()) {
            builderMap.put(builder.getTDSType(), builder);
        }
    }

    static final class Builder
    extends Enum<Builder> {
        public static final /* enum */ Builder BIT = new Builder(TDSType.BIT1, new FixedLenStrategy(SSType.BIT, 1, 1, "1".length(), 0));
        public static final /* enum */ Builder BIGINT = new Builder(TDSType.INT8, new FixedLenStrategy(SSType.BIGINT, 8, Long.toString(Long.MAX_VALUE).length(), ("-" + Long.toString(Long.MAX_VALUE)).length(), 0));
        public static final /* enum */ Builder INTEGER = new Builder(TDSType.INT4, new FixedLenStrategy(SSType.INTEGER, 4, Integer.toString(Integer.MAX_VALUE).length(), ("-" + Integer.toString(Integer.MAX_VALUE)).length(), 0));
        public static final /* enum */ Builder SMALLINT = new Builder(TDSType.INT2, new FixedLenStrategy(SSType.SMALLINT, 2, Short.toString((short)Short.MAX_VALUE).length(), ("-" + Short.toString((short)Short.MAX_VALUE)).length(), 0));
        public static final /* enum */ Builder TINYINT = new Builder(TDSType.INT1, new FixedLenStrategy(SSType.TINYINT, 1, Byte.toString((byte)127).length(), Byte.toString((byte)127).length(), 0));
        public static final /* enum */ Builder REAL = new Builder(TDSType.FLOAT4, new FixedLenStrategy(SSType.REAL, 4, 7, 13, 0));
        public static final /* enum */ Builder FLOAT = new Builder(TDSType.FLOAT8, new FixedLenStrategy(SSType.FLOAT, 8, 15, 22, 0));
        public static final /* enum */ Builder SMALLDATETIME = new Builder(TDSType.DATETIME4, new FixedLenStrategy(SSType.SMALLDATETIME, 4, "yyyy-mm-dd hh:mm".length(), "yyyy-mm-dd hh:mm".length(), 0));
        public static final /* enum */ Builder DATETIME = new Builder(TDSType.DATETIME8, new FixedLenStrategy(SSType.DATETIME, 8, "yyyy-mm-dd hh:mm:ss.fff".length(), "yyyy-mm-dd hh:mm:ss.fff".length(), 3));
        public static final /* enum */ Builder SMALLMONEY = new Builder(TDSType.MONEY4, new FixedLenStrategy(SSType.SMALLMONEY, 4, Integer.toString(Integer.MAX_VALUE).length(), ("-." + Integer.toString(Integer.MAX_VALUE)).length(), 4));
        public static final /* enum */ Builder MONEY = new Builder(TDSType.MONEY8, new FixedLenStrategy(SSType.MONEY, 8, Long.toString(Long.MAX_VALUE).length(), ("-." + Long.toString(Long.MAX_VALUE)).length(), 4));
        public static final /* enum */ Builder BITN = new Builder(TDSType.BITN, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                if (1 != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                BIT.build(typeInfo, tDSReader);
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
            }
        });
        public static final /* enum */ Builder INTN = new Builder(TDSType.INTN, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                switch (tDSReader.readUnsignedByte()) {
                    case 8: {
                        BIGINT.build(typeInfo, tDSReader);
                        break;
                    }
                    case 4: {
                        INTEGER.build(typeInfo, tDSReader);
                        break;
                    }
                    case 2: {
                        SMALLINT.build(typeInfo, tDSReader);
                        break;
                    }
                    case 1: {
                        TINYINT.build(typeInfo, tDSReader);
                        break;
                    }
                    default: {
                        tDSReader.throwInvalidTDS();
                    }
                }
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
            }
        });
        public static final /* enum */ Builder DECIMAL = new Builder(TDSType.DECIMALN, new DecimalNumericStrategy(SSType.DECIMAL));
        public static final /* enum */ Builder NUMERIC = new Builder(TDSType.NUMERICN, new DecimalNumericStrategy(SSType.NUMERIC));
        public static final /* enum */ Builder FLOATN = new Builder(TDSType.FLOATN, new BigOrSmallByteLenStrategy(FLOAT, REAL));
        public static final /* enum */ Builder MONEYN = new Builder(TDSType.MONEYN, new BigOrSmallByteLenStrategy(MONEY, SMALLMONEY));
        public static final /* enum */ Builder DATETIMEN = new Builder(TDSType.DATETIMEN, new BigOrSmallByteLenStrategy(DATETIME, SMALLDATETIME));
        public static final /* enum */ Builder TIME = new Builder(TDSType.TIMEN, new KatmaiScaledTemporalStrategy(SSType.TIME));
        public static final /* enum */ Builder DATETIME2 = new Builder(TDSType.DATETIME2N, new KatmaiScaledTemporalStrategy(SSType.DATETIME2));
        public static final /* enum */ Builder DATETIMEOFFSET = new Builder(TDSType.DATETIMEOFFSETN, new KatmaiScaledTemporalStrategy(SSType.DATETIMEOFFSET));
        public static final /* enum */ Builder DATE = new Builder(TDSType.DATEN, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssType = SSType.DATE;
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
                typeInfo.maxLength = 3;
                typeInfo.displaySize = (typeInfo.precision = "yyyy-mm-dd".length());
            }
        });
        public static final /* enum */ Builder BIGBINARY = new Builder(TDSType.BIGBINARY, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (typeInfo.maxLength > 8000) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.precision = typeInfo.maxLength;
                typeInfo.displaySize = 2 * typeInfo.maxLength;
                typeInfo.ssType = 80 == typeInfo.userType ? SSType.TIMESTAMP : SSType.BINARY;
            }
        });
        public static final /* enum */ Builder BIGVARBINARY = new Builder(TDSType.BIGVARBINARY, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (65535 == typeInfo.maxLength) {
                    typeInfo.ssLenType = SSLenType.PARTLENTYPE;
                    typeInfo.ssType = SSType.VARBINARYMAX;
                    typeInfo.displaySize = (typeInfo.precision = Integer.MAX_VALUE);
                } else if (typeInfo.maxLength <= 8000) {
                    typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                    typeInfo.ssType = SSType.VARBINARY;
                    typeInfo.precision = typeInfo.maxLength;
                    typeInfo.displaySize = 2 * typeInfo.maxLength;
                } else {
                    tDSReader.throwInvalidTDS();
                }
            }
        });
        public static final /* enum */ Builder IMAGE = new Builder(TDSType.IMAGE, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.LONGLENTYPE;
                typeInfo.maxLength = tDSReader.readInt();
                if (typeInfo.maxLength < 0) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssType = SSType.IMAGE;
                typeInfo.displaySize = (typeInfo.precision = Integer.MAX_VALUE);
            }
        });
        public static final /* enum */ Builder BIGCHAR = new Builder(TDSType.BIGCHAR, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (typeInfo.maxLength > 8000) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.displaySize = (typeInfo.precision = typeInfo.maxLength);
                typeInfo.ssType = SSType.CHAR;
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = typeInfo.collation.getCharset();
            }
        });
        public static final /* enum */ Builder BIGVARCHAR = new Builder(TDSType.BIGVARCHAR, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (65535 == typeInfo.maxLength) {
                    typeInfo.ssLenType = SSLenType.PARTLENTYPE;
                    typeInfo.ssType = SSType.VARCHARMAX;
                    typeInfo.displaySize = (typeInfo.precision = Integer.MAX_VALUE);
                } else if (typeInfo.maxLength <= 8000) {
                    typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                    typeInfo.ssType = SSType.VARCHAR;
                    typeInfo.displaySize = (typeInfo.precision = typeInfo.maxLength);
                } else {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = typeInfo.collation.getCharset();
            }
        });
        public static final /* enum */ Builder TEXT = new Builder(TDSType.TEXT, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.LONGLENTYPE;
                typeInfo.maxLength = tDSReader.readInt();
                if (typeInfo.maxLength < 0) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssType = SSType.TEXT;
                typeInfo.displaySize = (typeInfo.precision = Integer.MAX_VALUE);
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = typeInfo.collation.getCharset();
            }
        });
        public static final /* enum */ Builder NCHAR = new Builder(TDSType.NCHAR, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (typeInfo.maxLength > 8000 || 0 != typeInfo.maxLength % 2) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.displaySize = (typeInfo.precision = typeInfo.maxLength / 2);
                typeInfo.ssType = SSType.NCHAR;
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = Encoding.UNICODE.charsetName();
            }
        });
        public static final /* enum */ Builder NVARCHAR = new Builder(TDSType.NVARCHAR, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.maxLength = tDSReader.readUnsignedShort();
                if (65535 == typeInfo.maxLength) {
                    typeInfo.ssLenType = SSLenType.PARTLENTYPE;
                    typeInfo.ssType = SSType.NVARCHARMAX;
                    typeInfo.displaySize = (typeInfo.precision = 0x3FFFFFFF);
                } else if (typeInfo.maxLength <= 8000 && 0 == typeInfo.maxLength % 2) {
                    typeInfo.ssLenType = SSLenType.USHORTLENTYPE;
                    typeInfo.ssType = SSType.NVARCHAR;
                    typeInfo.displaySize = (typeInfo.precision = typeInfo.maxLength / 2);
                } else {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = Encoding.UNICODE.charsetName();
            }
        });
        public static final /* enum */ Builder NTEXT = new Builder(TDSType.NTEXT, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.ssLenType = SSLenType.LONGLENTYPE;
                typeInfo.maxLength = tDSReader.readInt();
                if (typeInfo.maxLength < 0) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssType = SSType.NTEXT;
                typeInfo.displaySize = (typeInfo.precision = 0x3FFFFFFF);
                typeInfo.collation = tDSReader.readCollation();
                typeInfo.charset = Encoding.UNICODE.charsetName();
            }
        });
        public static final /* enum */ Builder GUID = new Builder(TDSType.GUID, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                int n = tDSReader.readUnsignedByte();
                if (n != 16 && n != 0) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
                typeInfo.ssType = SSType.GUID;
                typeInfo.maxLength = n;
                typeInfo.displaySize = (typeInfo.precision = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN".length());
            }
        });
        public static final /* enum */ Builder UDT = new Builder(TDSType.UDT, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                UDTTDSHeader uDTTDSHeader = new UDTTDSHeader(tDSReader);
                typeInfo.maxLength = uDTTDSHeader.getMaxLen();
                if (65535 == typeInfo.maxLength) {
                    typeInfo.precision = Integer.MAX_VALUE;
                    typeInfo.displaySize = Integer.MAX_VALUE;
                } else if (typeInfo.maxLength <= 8000) {
                    typeInfo.precision = typeInfo.maxLength;
                    typeInfo.displaySize = 2 * typeInfo.maxLength;
                } else {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssLenType = SSLenType.PARTLENTYPE;
                typeInfo.ssType = SSType.UDT;
                typeInfo.udtTypeName = uDTTDSHeader.getTypeName();
            }
        });
        public static final /* enum */ Builder XML = new Builder(TDSType.XML, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                XMLTDSHeader xMLTDSHeader = new XMLTDSHeader(tDSReader);
                typeInfo.ssLenType = SSLenType.PARTLENTYPE;
                typeInfo.ssType = SSType.XML;
                typeInfo.displaySize = (typeInfo.precision = 0x3FFFFFFF);
                typeInfo.charset = Encoding.UNICODE.charsetName();
            }
        });
        public static final /* enum */ Builder SQL_VARIANT = new Builder(TDSType.SQL_VARIANT, new Strategy(){

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                SQLServerException.makeFromDriverError(tDSReader.getConnection(), null, SQLServerException.getErrString("R_variantNotSupported"), "08006", false);
            }
        });
        private final TDSType tdsType;
        private final Strategy strategy;
        private static final /* synthetic */ Builder[] $VALUES;

        public static Builder[] values() {
            return (Builder[])$VALUES.clone();
        }

        public static Builder valueOf(String string) {
            return Enum.valueOf(Builder.class, string);
        }

        private Builder(TDSType tDSType, Strategy strategy) {
            this.tdsType = tDSType;
            this.strategy = strategy;
        }

        final TDSType getTDSType() {
            return this.tdsType;
        }

        final TypeInfo build(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
            this.strategy.apply(typeInfo, tDSReader);
            assert (null != typeInfo.ssType);
            assert (null != typeInfo.ssLenType);
            return typeInfo;
        }

        static {
            $VALUES = new Builder[]{BIT, BIGINT, INTEGER, SMALLINT, TINYINT, REAL, FLOAT, SMALLDATETIME, DATETIME, SMALLMONEY, MONEY, BITN, INTN, DECIMAL, NUMERIC, FLOATN, MONEYN, DATETIMEN, TIME, DATETIME2, DATETIMEOFFSET, DATE, BIGBINARY, BIGVARBINARY, IMAGE, BIGCHAR, BIGVARCHAR, TEXT, NCHAR, NVARCHAR, NTEXT, GUID, UDT, XML, SQL_VARIANT};
        }

        private static final class KatmaiScaledTemporalStrategy
        implements Strategy {
            private final SSType ssType;

            KatmaiScaledTemporalStrategy(SSType sSType) {
                this.ssType = sSType;
            }

            private int getPrecision(String string, int n) {
                return string.length() + (n > 0 ? 1 + n : 0);
            }

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                typeInfo.scale = tDSReader.readUnsignedByte();
                if (typeInfo.scale > 7) {
                    tDSReader.throwInvalidTDS();
                }
                switch (this.ssType) {
                    case TIME: {
                        typeInfo.precision = this.getPrecision("hh:mm:ss", typeInfo.scale);
                        typeInfo.maxLength = TDS.timeValueLength(typeInfo.scale);
                        break;
                    }
                    case DATETIME2: {
                        typeInfo.precision = this.getPrecision("yyyy-mm-dd hh:mm:ss", typeInfo.scale);
                        typeInfo.maxLength = TDS.datetime2ValueLength(typeInfo.scale);
                        break;
                    }
                    case DATETIMEOFFSET: {
                        typeInfo.precision = this.getPrecision("yyyy-mm-dd hh:mm:ss +HH:MM", typeInfo.scale);
                        typeInfo.maxLength = TDS.datetimeoffsetValueLength(typeInfo.scale);
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected SSType: " + (Object)((Object)this.ssType);
                        break;
                    }
                }
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
                typeInfo.ssType = this.ssType;
                typeInfo.displaySize = typeInfo.precision;
            }
        }

        private static final class BigOrSmallByteLenStrategy
        implements Strategy {
            private final Builder bigBuilder;
            private final Builder smallBuilder;

            BigOrSmallByteLenStrategy(Builder builder, Builder builder2) {
                this.bigBuilder = builder;
                this.smallBuilder = builder2;
            }

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                switch (tDSReader.readUnsignedByte()) {
                    case 8: {
                        this.bigBuilder.build(typeInfo, tDSReader);
                        break;
                    }
                    case 4: {
                        this.smallBuilder.build(typeInfo, tDSReader);
                        break;
                    }
                    default: {
                        tDSReader.throwInvalidTDS();
                    }
                }
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
            }
        }

        private static final class DecimalNumericStrategy
        implements Strategy {
            private final SSType ssType;

            DecimalNumericStrategy(SSType sSType) {
                this.ssType = sSType;
            }

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
                int n = tDSReader.readUnsignedByte();
                int n2 = tDSReader.readUnsignedByte();
                int n3 = tDSReader.readUnsignedByte();
                if (n > 17) {
                    tDSReader.throwInvalidTDS();
                }
                typeInfo.ssLenType = SSLenType.BYTELENTYPE;
                typeInfo.ssType = this.ssType;
                typeInfo.maxLength = n;
                typeInfo.precision = n2;
                typeInfo.displaySize = n2 + 2;
                typeInfo.scale = n3;
            }
        }

        private static final class FixedLenStrategy
        implements Strategy {
            private final SSType ssType;
            private final int maxLength;
            private final int precision;
            private final int displaySize;
            private final int scale;

            FixedLenStrategy(SSType sSType, int n, int n2, int n3, int n4) {
                this.ssType = sSType;
                this.maxLength = n;
                this.precision = n2;
                this.displaySize = n3;
                this.scale = n4;
            }

            @Override
            public void apply(TypeInfo typeInfo, TDSReader tDSReader) {
                typeInfo.ssLenType = SSLenType.FIXEDLENTYPE;
                typeInfo.ssType = this.ssType;
                typeInfo.maxLength = this.maxLength;
                typeInfo.precision = this.precision;
                typeInfo.displaySize = this.displaySize;
                typeInfo.scale = this.scale;
            }
        }

        private static interface Strategy {
            public void apply(TypeInfo var1, TDSReader var2) throws SQLServerException;
        }
    }
}

