/*
 * Decompiled with CFR 0.152.
 */
package javabd_mapeo.core;

import browsersql5_v1.BrowserSQL5;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javabd_mapeo.core.Metas;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

public class UsarConexion {
    Connection miConexion;
    Statement sentencia = null;
    ResultSet resultado;

    public UsarConexion(Connection c) {
        this.miConexion = c;
    }

    public int ABM(String cadena) {
        int operacionesHechas = 0;
        try {
            this.sentencia = this.miConexion.createStatement();
            operacionesHechas = this.sentencia.executeUpdate(cadena);
            if (!this.miConexion.getAutoCommit()) {
                this.miConexion.commit();
            }
        }
        catch (SQLException ex) {
            operacionesHechas = -10;
            String mensajeExcepcion = "Error al realizar la ABM: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return operacionesHechas;
    }

    public void Consultar(String cadena) {
        try {
            this.sentencia = this.miConexion.createStatement();
            this.sentencia.executeQuery(cadena);
            this.resultado = this.sentencia.getResultSet();
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al realizar la Consulta: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getCantidadRegistros() {
        int cantFilas = 0;
        try {
            this.resultado.last();
            cantFilas = this.resultado.getRow();
            this.resultado.first();
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al devolver la cantidad de columnas: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cantFilas;
    }

    public int getCantidadColumnasTabla() {
        int cantCols = 0;
        try {
            cantCols = this.resultado.getMetaData().getColumnCount();
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al devolver la cantidad de columnas: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cantCols;
    }

    public String getNombreColumnaTabla(int columna) {
        String nombre = "";
        try {
            nombre = this.resultado.getMetaData().getColumnLabel(columna);
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al devolver el nombre de la columna: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nombre;
    }

    public int getTamanioColumnaTabla(int columna) {
        int cantidad = 0;
        try {
            cantidad = this.resultado.getMetaData().getColumnDisplaySize(columna);
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al devolver el tama\u00f1o de la columna: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cantidad;
    }

    public String[] getObtenerNombresColumnas() {
        int cantCols = this.getCantidadColumnasTabla();
        String[] nomCols = new String[cantCols];
        for (int i = 0; i < cantCols; ++i) {
            nomCols[i] = new StringBuilder(this.getTamanioColumnaTabla(i + 1)).toString();
            nomCols[i] = this.getNombreColumnaTabla(i + 1) + "  |  ";
        }
        return nomCols;
    }

    public String getObtenerDatos() {
        String datos = "";
        try {
            int cantCols = this.getCantidadColumnasTabla();
            while (this.resultado.next()) {
                String fila = "";
                for (int i = 0; i < cantCols; ++i) {
                    fila = fila + this.resultado.getString(i + 1) + " | ";
                }
                datos = datos + "\n" + fila;
            }
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al leer los datos del RecordSet: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return datos;
    }

    public String[] getObtenerDatosClave() {
        int cantCols = this.getCantidadColumnasTabla();
        String[] datos = new String[cantCols];
        try {
            while (this.resultado.next()) {
                for (int i = 0; i < cantCols; ++i) {
                    datos[i] = this.resultado.getString(i + 1);
                }
            }
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al leer los datos del RecordSet: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(BrowserSQL5.panelSuperior, mensajeExcepcion, "Excepci\u00f3n !!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return datos;
    }

    public void consultarMetas() {
        Metas metas = new Metas();
        this.resultado = metas.getMetadatosDB();
    }

    public void consultarTablas() {
        Metas metas = new Metas();
        this.resultado = metas.getContenidoTablas();
    }

    public void consultarClavesPrimarias(String nombre) {
        Metas metas = new Metas();
        this.resultado = metas.getClavesPrimarias(nombre);
    }

    public void consultarForaneas(String nombre) {
        Metas metas = new Metas();
        this.resultado = metas.getClavesForaneas(nombre);
    }

    public void consultarColumnas(String nombre) {
        Metas metas = new Metas();
        this.resultado = metas.getTablaColumnas(nombre);
    }

    public String[] getObtenerNombresColumnasJTable() {
        int cantCols = this.getCantidadColumnasTabla();
        String[] nomCols = new String[cantCols];
        for (int i = 0; i < cantCols; ++i) {
            nomCols[i] = new StringBuilder(this.getTamanioColumnaTabla(i + 1)).toString();
            nomCols[i] = this.getNombreColumnaTabla(i + 1);
        }
        return nomCols;
    }

    public DefaultTableModel getObtenerDatosJTable() {
        DefaultTableModel modelo = null;
        try {
            Object[] tupla = new String[this.getCantidadColumnasTabla()];
            Object[] titulos = this.getObtenerNombresColumnasJTable();
            modelo = new DefaultTableModel((Object[][])null, titulos);
            while (this.resultado.next()) {
                int j = 1;
                for (int i = 0; i < tupla.length; ++i) {
                    tupla[i] = this.resultado.getString(this.getNombreColumnaTabla(j++));
                }
                modelo.addRow(tupla);
            }
        }
        catch (SQLException ex) {
            String mensajeExcepcion = "Error al leer los datos del RecordSet: \n" + ex.getMessage() + "\nLocalizaci\u00f3n: " + ex.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, mensajeExcepcion, "Excepci\u00f3n!", 0);
            Logger.getLogger(UsarConexion.class.getName()).log(Level.SEVERE, null, ex);
        }
        return modelo;
    }
}

